/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.math.linearalgebra;

import java.security.SecureRandom;
import java.util.Vector;
import org.bouncycastle.pqc.math.linearalgebra.GF2Polynomial;
import org.bouncycastle.pqc.math.linearalgebra.GF2nElement;
import org.bouncycastle.pqc.math.linearalgebra.GF2nONBElement;
import org.bouncycastle.pqc.math.linearalgebra.GF2nONBField;
import org.bouncycastle.pqc.math.linearalgebra.GF2nPolynomialElement;
import org.bouncycastle.pqc.math.linearalgebra.GF2nPolynomialField;

public abstract class GF2nField {
    protected final SecureRandom random;
    protected int mDegree;
    protected GF2Polynomial fieldPolynomial;
    protected Vector fields;
    protected Vector matrices;

    protected GF2nField(SecureRandom random) {
        this.random = random;
    }

    public final int getDegree() {
        return this.mDegree;
    }

    public final GF2Polynomial getFieldPolynomial() {
        if (this.fieldPolynomial == null) {
            this.computeFieldPolynomial();
        }
        return new GF2Polynomial(this.fieldPolynomial);
    }

    public final boolean equals(Object other) {
        if (other == null || !(other instanceof GF2nField)) {
            return false;
        }
        GF2nField otherField = (GF2nField)other;
        if (otherField.mDegree != this.mDegree) {
            return false;
        }
        if (!this.fieldPolynomial.equals(otherField.fieldPolynomial)) {
            return false;
        }
        if (this instanceof GF2nPolynomialField && !(otherField instanceof GF2nPolynomialField)) {
            return false;
        }
        return !(this instanceof GF2nONBField) || otherField instanceof GF2nONBField;
    }

    public int hashCode() {
        return this.mDegree + this.fieldPolynomial.hashCode();
    }

    protected abstract GF2nElement getRandomRoot(GF2Polynomial var1);

    protected abstract void computeCOBMatrix(GF2nField var1);

    protected abstract void computeFieldPolynomial();

    protected final GF2Polynomial[] invertMatrix(GF2Polynomial[] matrix) {
        int j;
        GF2Polynomial[] a = new GF2Polynomial[matrix.length];
        GF2Polynomial[] inv = new GF2Polynomial[matrix.length];
        int i = 0;
        while (i < this.mDegree) {
            try {
                a[i] = new GF2Polynomial(matrix[i]);
                inv[i] = new GF2Polynomial(this.mDegree);
                inv[i].setBit(this.mDegree - 1 - i);
            }
            catch (RuntimeException BDNEExc) {
                BDNEExc.printStackTrace();
            }
            ++i;
        }
        i = 0;
        while (i < this.mDegree - 1) {
            j = i;
            while (j < this.mDegree && !a[j].testBit(this.mDegree - 1 - i)) {
                ++j;
            }
            if (j >= this.mDegree) {
                throw new RuntimeException("GF2nField.invertMatrix: Matrix cannot be inverted!");
            }
            if (i != j) {
                GF2Polynomial dummy = a[i];
                a[i] = a[j];
                a[j] = dummy;
                dummy = inv[i];
                inv[i] = inv[j];
                inv[j] = dummy;
            }
            j = i + 1;
            while (j < this.mDegree) {
                if (a[j].testBit(this.mDegree - 1 - i)) {
                    a[j].addToThis(a[i]);
                    inv[j].addToThis(inv[i]);
                }
                ++j;
            }
            ++i;
        }
        i = this.mDegree - 1;
        while (i > 0) {
            j = i - 1;
            while (j >= 0) {
                if (a[j].testBit(this.mDegree - 1 - i)) {
                    a[j].addToThis(a[i]);
                    inv[j].addToThis(inv[i]);
                }
                --j;
            }
            --i;
        }
        return inv;
    }

    public final GF2nElement convert(GF2nElement elem, GF2nField basis) throws RuntimeException {
        if (basis == this) {
            return (GF2nElement)elem.clone();
        }
        if (this.fieldPolynomial.equals(basis.fieldPolynomial)) {
            return (GF2nElement)elem.clone();
        }
        if (this.mDegree != basis.mDegree) {
            throw new RuntimeException("GF2nField.convert: B1 has a different degree and thus cannot be coverted to!");
        }
        int i = this.fields.indexOf(basis);
        if (i == -1) {
            this.computeCOBMatrix(basis);
            i = this.fields.indexOf(basis);
        }
        GF2Polynomial[] COBMatrix = (GF2Polynomial[])this.matrices.elementAt(i);
        GF2nElement elemCopy = (GF2nElement)elem.clone();
        if (elemCopy instanceof GF2nONBElement) {
            ((GF2nONBElement)elemCopy).reverseOrder();
        }
        GF2Polynomial bs = new GF2Polynomial(this.mDegree, elemCopy.toFlexiBigInt());
        bs.expandN(this.mDegree);
        GF2Polynomial result = new GF2Polynomial(this.mDegree);
        i = 0;
        while (i < this.mDegree) {
            if (bs.vectorMult(COBMatrix[i])) {
                result.setBit(this.mDegree - 1 - i);
            }
            ++i;
        }
        if (basis instanceof GF2nPolynomialField) {
            return new GF2nPolynomialElement((GF2nPolynomialField)basis, result);
        }
        if (basis instanceof GF2nONBField) {
            GF2nONBElement res = new GF2nONBElement((GF2nONBField)basis, result.toFlexiBigInt());
            res.reverseOrder();
            return res;
        }
        throw new RuntimeException("GF2nField.convert: B1 must be an instance of GF2nPolynomialField or GF2nONBField!");
    }
}

