/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator.jcajce;

import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import org.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import org.bouncycastle.jcajce.util.NamedJcaJceHelper;
import org.bouncycastle.jcajce.util.ProviderJcaJceHelper;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPRuntimeOperationException;
import org.bouncycastle.openpgp.operator.PGPContentSigner;
import org.bouncycastle.openpgp.operator.PGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPDigestCalculatorProviderBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPKeyConverter;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPPrivateKey;
import org.bouncycastle.openpgp.operator.jcajce.OperatorHelper;
import org.bouncycastle.openpgp.operator.jcajce.SignatureOutputStream;
import org.bouncycastle.util.io.TeeOutputStream;

public class JcaPGPContentSignerBuilder
implements PGPContentSignerBuilder {
    private OperatorHelper helper = new OperatorHelper(new DefaultJcaJceHelper());
    private JcaPGPDigestCalculatorProviderBuilder digestCalculatorProviderBuilder = new JcaPGPDigestCalculatorProviderBuilder();
    private JcaPGPKeyConverter keyConverter = new JcaPGPKeyConverter();
    private int hashAlgorithm;
    private SecureRandom random;
    private int keyAlgorithm;

    public JcaPGPContentSignerBuilder(int keyAlgorithm, int hashAlgorithm) {
        this.keyAlgorithm = keyAlgorithm;
        this.hashAlgorithm = hashAlgorithm;
    }

    public JcaPGPContentSignerBuilder setSecureRandom(SecureRandom random) {
        this.random = random;
        return this;
    }

    public JcaPGPContentSignerBuilder setProvider(Provider provider) {
        this.helper = new OperatorHelper(new ProviderJcaJceHelper(provider));
        this.keyConverter.setProvider(provider);
        this.digestCalculatorProviderBuilder.setProvider(provider);
        return this;
    }

    public JcaPGPContentSignerBuilder setProvider(String providerName) {
        this.helper = new OperatorHelper(new NamedJcaJceHelper(providerName));
        this.keyConverter.setProvider(providerName);
        this.digestCalculatorProviderBuilder.setProvider(providerName);
        return this;
    }

    public JcaPGPContentSignerBuilder setDigestProvider(Provider provider) {
        this.digestCalculatorProviderBuilder.setProvider(provider);
        return this;
    }

    public JcaPGPContentSignerBuilder setDigestProvider(String providerName) {
        this.digestCalculatorProviderBuilder.setProvider(providerName);
        return this;
    }

    @Override
    public PGPContentSigner build(int signatureType, PGPPrivateKey privateKey) throws PGPException {
        if (privateKey instanceof JcaPGPPrivateKey) {
            return this.build(signatureType, privateKey.getKeyID(), ((JcaPGPPrivateKey)privateKey).getPrivateKey());
        }
        return this.build(signatureType, privateKey.getKeyID(), this.keyConverter.getPrivateKey(privateKey));
    }

    public PGPContentSigner build(final int signatureType, final long keyID, PrivateKey privateKey) throws PGPException {
        final PGPDigestCalculator digestCalculator = this.digestCalculatorProviderBuilder.build().get(this.hashAlgorithm);
        final Signature signature = this.helper.createSignature(this.keyAlgorithm, this.hashAlgorithm);
        try {
            if (this.random != null) {
                signature.initSign(privateKey, this.random);
            } else {
                signature.initSign(privateKey);
            }
        }
        catch (InvalidKeyException e) {
            throw new PGPException("invalid key.", e);
        }
        return new PGPContentSigner(){

            @Override
            public int getType() {
                return signatureType;
            }

            @Override
            public int getHashAlgorithm() {
                return JcaPGPContentSignerBuilder.this.hashAlgorithm;
            }

            @Override
            public int getKeyAlgorithm() {
                return JcaPGPContentSignerBuilder.this.keyAlgorithm;
            }

            @Override
            public long getKeyID() {
                return keyID;
            }

            @Override
            public OutputStream getOutputStream() {
                return new TeeOutputStream(new SignatureOutputStream(signature), digestCalculator.getOutputStream());
            }

            @Override
            public byte[] getSignature() {
                try {
                    return signature.sign();
                }
                catch (SignatureException e) {
                    throw new PGPRuntimeOperationException("Unable to create signature: " + e.getMessage(), e);
                }
            }

            @Override
            public byte[] getDigest() {
                return digestCalculator.getDigest();
            }
        };
    }
}

