/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.bouncycastle.bcpg.BCPGInputStream;
import org.bouncycastle.bcpg.ContainedPacket;
import org.bouncycastle.bcpg.PublicKeyPacket;
import org.bouncycastle.bcpg.PublicSubkeyPacket;
import org.bouncycastle.bcpg.SecretKeyPacket;
import org.bouncycastle.bcpg.SecretSubkeyPacket;
import org.bouncycastle.bcpg.TrustPacket;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.PBESecretKeyDecryptor;
import org.bouncycastle.openpgp.operator.PBESecretKeyEncryptor;
import org.bouncycastle.util.Iterable;

public class PGPSecretKeyRing
extends PGPKeyRing
implements Iterable<PGPSecretKey> {
    List keys;
    List extraPubKeys;

    PGPSecretKeyRing(List keys) {
        this(keys, new ArrayList());
    }

    private PGPSecretKeyRing(List keys, List extraPubKeys) {
        this.keys = keys;
        this.extraPubKeys = extraPubKeys;
    }

    public PGPSecretKeyRing(byte[] encoding, KeyFingerPrintCalculator fingerPrintCalculator) throws IOException, PGPException {
        this(new ByteArrayInputStream(encoding), fingerPrintCalculator);
    }

    public PGPSecretKeyRing(InputStream in, KeyFingerPrintCalculator fingerPrintCalculator) throws IOException, PGPException {
        this.keys = new ArrayList();
        this.extraPubKeys = new ArrayList();
        BCPGInputStream pIn = PGPSecretKeyRing.wrap(in);
        int initialTag = pIn.nextPacketTag();
        if (initialTag != 5 && initialTag != 7) {
            throw new IOException("secret key ring doesn't start with secret key tag: tag 0x" + Integer.toHexString(initialTag));
        }
        SecretKeyPacket secret = (SecretKeyPacket)pIn.readPacket();
        while (pIn.nextPacketTag() == 61) {
            pIn.readPacket();
        }
        TrustPacket trust = PGPSecretKeyRing.readOptionalTrustPacket(pIn);
        List keySigs = PGPSecretKeyRing.readSignaturesAndTrust(pIn);
        ArrayList ids = new ArrayList();
        ArrayList idTrusts = new ArrayList();
        ArrayList idSigs = new ArrayList();
        PGPSecretKeyRing.readUserIDs(pIn, ids, idTrusts, idSigs);
        this.keys.add(new PGPSecretKey(secret, new PGPPublicKey(secret.getPublicKeyPacket(), trust, keySigs, ids, idTrusts, idSigs, fingerPrintCalculator)));
        while (pIn.nextPacketTag() == 7 || pIn.nextPacketTag() == 14) {
            List sigList;
            TrustPacket subTrust;
            ContainedPacket sub;
            if (pIn.nextPacketTag() == 7) {
                sub = (SecretSubkeyPacket)pIn.readPacket();
                while (pIn.nextPacketTag() == 61) {
                    pIn.readPacket();
                }
                subTrust = PGPSecretKeyRing.readOptionalTrustPacket(pIn);
                sigList = PGPSecretKeyRing.readSignaturesAndTrust(pIn);
                this.keys.add(new PGPSecretKey((SecretKeyPacket)sub, new PGPPublicKey(((SecretKeyPacket)sub).getPublicKeyPacket(), subTrust, sigList, fingerPrintCalculator)));
                continue;
            }
            sub = (PublicSubkeyPacket)pIn.readPacket();
            subTrust = PGPSecretKeyRing.readOptionalTrustPacket(pIn);
            sigList = PGPSecretKeyRing.readSignaturesAndTrust(pIn);
            this.extraPubKeys.add(new PGPPublicKey((PublicKeyPacket)sub, subTrust, sigList, fingerPrintCalculator));
        }
    }

    @Override
    public PGPPublicKey getPublicKey() {
        return ((PGPSecretKey)this.keys.get(0)).getPublicKey();
    }

    @Override
    public PGPPublicKey getPublicKey(long keyID) {
        PGPSecretKey key = this.getSecretKey(keyID);
        if (key != null) {
            return key.getPublicKey();
        }
        int i = 0;
        while (i != this.extraPubKeys.size()) {
            PGPPublicKey k = (PGPPublicKey)this.keys.get(i);
            if (keyID == k.getKeyID()) {
                return k;
            }
            ++i;
        }
        return null;
    }

    @Override
    public Iterator<PGPPublicKey> getPublicKeys() {
        ArrayList<PGPPublicKey> pubKeys = new ArrayList<PGPPublicKey>();
        Iterator<PGPSecretKey> it = this.getSecretKeys();
        while (it.hasNext()) {
            pubKeys.add(it.next().getPublicKey());
        }
        pubKeys.addAll(this.extraPubKeys);
        return Collections.unmodifiableList(pubKeys).iterator();
    }

    public PGPSecretKey getSecretKey() {
        return (PGPSecretKey)this.keys.get(0);
    }

    public Iterator<PGPSecretKey> getSecretKeys() {
        return Collections.unmodifiableList(this.keys).iterator();
    }

    public PGPSecretKey getSecretKey(long keyId) {
        int i = 0;
        while (i != this.keys.size()) {
            PGPSecretKey k = (PGPSecretKey)this.keys.get(i);
            if (keyId == k.getKeyID()) {
                return k;
            }
            ++i;
        }
        return null;
    }

    public Iterator<PGPPublicKey> getExtraPublicKeys() {
        return this.extraPubKeys.iterator();
    }

    @Override
    public byte[] getEncoded() throws IOException {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        this.encode(bOut);
        return bOut.toByteArray();
    }

    @Override
    public void encode(OutputStream outStream) throws IOException {
        Object k;
        int i = 0;
        while (i != this.keys.size()) {
            k = (PGPSecretKey)this.keys.get(i);
            ((PGPSecretKey)k).encode(outStream);
            ++i;
        }
        i = 0;
        while (i != this.extraPubKeys.size()) {
            k = (PGPPublicKey)this.extraPubKeys.get(i);
            ((PGPPublicKey)k).encode(outStream);
            ++i;
        }
    }

    @Override
    public Iterator<PGPSecretKey> iterator() {
        return this.getSecretKeys();
    }

    public static PGPSecretKeyRing replacePublicKeys(PGPSecretKeyRing secretRing, PGPPublicKeyRing publicRing) {
        ArrayList<PGPSecretKey> newList = new ArrayList<PGPSecretKey>(secretRing.keys.size());
        for (PGPSecretKey sk : secretRing.keys) {
            PGPPublicKey pk = publicRing.getPublicKey(sk.getKeyID());
            newList.add(PGPSecretKey.replacePublicKey(sk, pk));
        }
        return new PGPSecretKeyRing(newList);
    }

    public static PGPSecretKeyRing copyWithNewPassword(PGPSecretKeyRing ring, PBESecretKeyDecryptor oldKeyDecryptor, PBESecretKeyEncryptor newKeyEncryptor) throws PGPException {
        ArrayList<PGPSecretKey> newKeys = new ArrayList<PGPSecretKey>(ring.keys.size());
        Iterator<PGPSecretKey> keys = ring.getSecretKeys();
        while (keys.hasNext()) {
            PGPSecretKey key = keys.next();
            if (key.isPrivateKeyEmpty()) {
                newKeys.add(key);
                continue;
            }
            newKeys.add(PGPSecretKey.copyWithNewPassword(key, oldKeyDecryptor, newKeyEncryptor));
        }
        return new PGPSecretKeyRing(newKeys, ring.extraPubKeys);
    }

    public static PGPSecretKeyRing insertSecretKey(PGPSecretKeyRing secRing, PGPSecretKey secKey) {
        ArrayList<PGPSecretKey> keys = new ArrayList<PGPSecretKey>(secRing.keys);
        boolean found = false;
        boolean masterFound = false;
        int i = 0;
        while (i != keys.size()) {
            PGPSecretKey key = (PGPSecretKey)keys.get(i);
            if (key.getKeyID() == secKey.getKeyID()) {
                found = true;
                keys.set(i, secKey);
            }
            if (key.isMasterKey()) {
                masterFound = true;
            }
            ++i;
        }
        if (!found) {
            if (secKey.isMasterKey()) {
                if (masterFound) {
                    throw new IllegalArgumentException("cannot add a master key to a ring that already has one");
                }
                keys.add(0, secKey);
            } else {
                keys.add(secKey);
            }
        }
        return new PGPSecretKeyRing(keys, secRing.extraPubKeys);
    }

    public static PGPSecretKeyRing removeSecretKey(PGPSecretKeyRing secRing, PGPSecretKey secKey) {
        ArrayList keys = new ArrayList(secRing.keys);
        boolean found = false;
        int i = 0;
        while (i < keys.size()) {
            PGPSecretKey key = (PGPSecretKey)keys.get(i);
            if (key.getKeyID() == secKey.getKeyID()) {
                found = true;
                keys.remove(i);
            }
            ++i;
        }
        if (!found) {
            return null;
        }
        return new PGPSecretKeyRing(keys, secRing.extraPubKeys);
    }
}

