/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.sdp;

import fm.icelink.ArrayExtensions;
import fm.icelink.Global;
import fm.icelink.IntegerExtensions;
import fm.icelink.ParseAssistant;
import fm.icelink.ShortExtensions;
import fm.icelink.StringAssistant;
import fm.icelink.StringBuilderExtensions;
import fm.icelink.StringExtensions;
import fm.icelink.sdp.UdpMedia;

public class Media {
    private static short _defaultNumberOfPorts = 1;
    private String _formatDescription;
    private String _mediaType;
    private short _numberOfPorts;
    private int _transportPort;
    private String _transportProtocol;

    public String getFormatDescription() {
        return this._formatDescription;
    }

    public String getMediaType() {
        return this._mediaType;
    }

    public short getNumberOfPorts() {
        return this._numberOfPorts;
    }

    public int getTransportPort() {
        return this._transportPort;
    }

    public String getTransportProtocol() {
        return this._transportProtocol;
    }

    public Media(String mediaType, int transportPort, String transportProtocol) {
        this(mediaType, transportPort, transportProtocol, null);
    }

    public Media(String mediaType, int transportPort, String transportProtocol, String formatDescription) {
        if (mediaType == null) {
            throw new RuntimeException(new Exception("mediaType cannot be null."));
        }
        if (transportProtocol == null) {
            throw new RuntimeException(new Exception("transportProtocol cannot be null."));
        }
        this.setMediaType(mediaType);
        this.setTransportPort(transportPort);
        this.setNumberOfPorts(_defaultNumberOfPorts);
        this.setTransportProtocol(transportProtocol);
        this.setFormatDescription(formatDescription);
    }

    public Media() {
    }

    public static Media parse(String s) {
        Media media;
        s = s.substring(2);
        String[] array = StringExtensions.split(s, new char[]{' '});
        String mediaType = array[0];
        Object[] strArray2 = StringExtensions.split(array[1], new char[]{'/'});
        int transportPort = ParseAssistant.parseIntegerValue(strArray2[0]);
        String transportProtocol = array[2];
        String formatDescription = StringExtensions.join(" ", StringAssistant.subArray(array, 3));
        if (Global.equals(transportProtocol, UdpMedia.getUdpTransportProtocol())) {
            media = new UdpMedia(mediaType, transportPort, formatDescription);
        } else if (Global.equals(transportProtocol, fm.icelink.sdp.rtp.Media.getRtpAvpTransportProtocol()) || Global.equals(transportProtocol, fm.icelink.sdp.rtp.Media.getRtpSavpTransportProtocol()) || Global.equals(transportProtocol, fm.icelink.sdp.rtp.Media.getRtpAvpfTransportProtocol()) || Global.equals(transportProtocol, fm.icelink.sdp.rtp.Media.getRtpSavpfTransportProtocol()) || Global.equals(transportProtocol, fm.icelink.sdp.rtp.Media.getUdpTlsRtpSavpTransportProtocol()) || Global.equals(transportProtocol, fm.icelink.sdp.rtp.Media.getUdpTlsRtpSavpfTransportProtocol())) {
            int[] rtpPayloadTypeNumbers = new int[]{};
            if (!StringExtensions.isNullOrEmpty(formatDescription)) {
                Object[] strArray3 = StringExtensions.split(formatDescription, new char[]{' '});
                rtpPayloadTypeNumbers = new int[ArrayExtensions.getLength(strArray3)];
                for (int i = 0; i < ArrayExtensions.getLength(rtpPayloadTypeNumbers); ++i) {
                    rtpPayloadTypeNumbers[i] = ParseAssistant.parseIntegerValue((String)strArray3[i]);
                }
            }
            media = new fm.icelink.sdp.rtp.Media(mediaType, transportPort, transportProtocol, rtpPayloadTypeNumbers);
        } else {
            media = Global.equals(transportProtocol, fm.icelink.sdp.sctp.Media.getDtlsSctpTransportProtocol()) || Global.equals(transportProtocol, fm.icelink.sdp.sctp.Media.getSctpDtlsTransportProtocol()) || Global.equals(transportProtocol, fm.icelink.sdp.sctp.Media.getSctpTransportProtocol()) || Global.equals(transportProtocol, fm.icelink.sdp.sctp.Media.getTcpDtlsSctpTransportProtocol()) || Global.equals(transportProtocol, fm.icelink.sdp.sctp.Media.getUdpDtlsSctpTransportProtocol()) ? new fm.icelink.sdp.sctp.Media(mediaType, transportPort, transportProtocol, formatDescription) : new Media(mediaType, transportPort, transportProtocol, formatDescription);
        }
        if (ArrayExtensions.getLength(strArray2) == 2) {
            media.setNumberOfPorts(ParseAssistant.parseShortValue((String)strArray2[1]));
        }
        return media;
    }

    public void setFormatDescription(String value) {
        this._formatDescription = value;
    }

    public void setMediaType(String value) {
        this._mediaType = value;
    }

    public void setNumberOfPorts(short value) {
        this._numberOfPorts = value;
    }

    public void setTransportPort(int value) {
        this._transportPort = value;
    }

    public void setTransportProtocol(String value) {
        this._transportProtocol = value;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        StringBuilderExtensions.append(builder, "m=");
        StringBuilderExtensions.append(builder, this.getMediaType());
        StringBuilderExtensions.append(builder, " ");
        StringBuilderExtensions.append(builder, IntegerExtensions.toString(this.getTransportPort()));
        if (this.getNumberOfPorts() > 1) {
            StringBuilderExtensions.append(builder, "/");
            StringBuilderExtensions.append(builder, ShortExtensions.toString(this.getNumberOfPorts()));
        }
        StringBuilderExtensions.append(builder, " ");
        StringBuilderExtensions.append(builder, this.getTransportProtocol());
        if (this.getFormatDescription() != null) {
            StringBuilderExtensions.append(builder, " ");
            StringBuilderExtensions.append(builder, this.getFormatDescription());
        }
        return builder.toString();
    }
}

