/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayExtensions;
import fm.icelink.Collection;
import fm.icelink.Dynamic;
import fm.icelink.Global;
import fm.icelink.MediaBuffer;
import fm.icelink.MediaBufferCollection;
import fm.icelink.MediaFormat;

public abstract class MediaFrame<TBuffer extends MediaBuffer<TFormat, TBuffer>, TBufferCollection extends MediaBufferCollection<TBuffer, TBufferCollection, TFormat>, TFormat extends MediaFormat<TFormat>, TFrame extends MediaFrame<TBuffer, TBufferCollection, TFormat, TFrame>>
extends Dynamic {
    private TBufferCollection __buffers;
    private long __synchronizationSource = -1L;
    private long[] _contributingSources;
    private double _duration;
    private long _rtpSequenceNumber;
    private long _rtpTimestamp;
    private long _sequenceNumber;
    private long _timestamp;

    public void addBuffer(TBuffer buffer) {
        ((Collection)this.__buffers).add(buffer);
    }

    public void addBuffers(TBuffer[] buffers) {
        ((Collection)this.__buffers).addMany(buffers);
    }

    public TFrame clone() {
        TFrame local = this.createInstance();
        local.addBuffers(this.getBuffers());
        ((MediaFrame)local).setSynchronizationSource(this.getSynchronizationSource());
        ((MediaFrame)local).setContributingSources(this.getContributingSources());
        ((MediaFrame)local).setTimestamp(this.getTimestamp());
        ((MediaFrame)local).setRtpTimestamp(this.getRtpTimestamp());
        ((MediaFrame)local).setSequenceNumber(this.getSequenceNumber());
        ((MediaFrame)local).setRtpSequenceNumber(this.getRtpSequenceNumber());
        ((MediaFrame)local).setDuration(this.getDuration());
        return local;
    }

    public abstract TFrame createInstance();

    protected abstract TBufferCollection createMediaBufferCollection();

    public TBuffer getBuffer(boolean isPacketized, boolean isEncrypted) {
        Object[] buffers = this.getBuffers();
        for (int i = ArrayExtensions.getLength(buffers) - 1; i >= 0; --i) {
            Object local = buffers[i];
            if (!Global.equals(((MediaFormat)((MediaBuffer)local).getFormat()).getIsPacketized(), isPacketized) || !Global.equals(((MediaFormat)((MediaBuffer)local).getFormat()).getIsEncrypted(), isEncrypted)) continue;
            return (TBuffer)local;
        }
        return null;
    }

    public TBuffer getBuffer() {
        return (TBuffer)((MediaBuffer)((Collection)this.__buffers).getValue());
    }

    public TBuffer getBuffer(TFormat format) {
        Object[] buffers = this.getBuffers();
        for (int i = ArrayExtensions.getLength(buffers) - 1; i >= 0; --i) {
            Object local = buffers[i];
            if (!((MediaFormat)((MediaBuffer)local).getFormat()).isEquivalent(format)) continue;
            return (TBuffer)local;
        }
        return null;
    }

    public TBuffer getBuffer(TFormat format, String sourceId) {
        Object[] buffers = this.getBuffers();
        for (int i = ArrayExtensions.getLength(buffers) - 1; i >= 0; --i) {
            Object local = buffers[i];
            if (!Global.equals(((MediaBuffer)local).getSourceId(), sourceId) || !((MediaFormat)((MediaBuffer)local).getFormat()).isEquivalent(format)) continue;
            return (TBuffer)local;
        }
        return null;
    }

    public TBuffer getBuffer(String formatName) {
        Object[] buffers = this.getBuffers();
        for (int i = ArrayExtensions.getLength(buffers) - 1; i >= 0; --i) {
            Object local = buffers[i];
            if (!Global.equals(((MediaFormat)((MediaBuffer)local).getFormat()).getName(), formatName)) continue;
            return (TBuffer)local;
        }
        return null;
    }

    public TBuffer getBuffer(boolean isPacketized) {
        Object[] buffers = this.getBuffers();
        for (int i = ArrayExtensions.getLength(buffers) - 1; i >= 0; --i) {
            Object local = buffers[i];
            if (!Global.equals(((MediaFormat)((MediaBuffer)local).getFormat()).getIsPacketized(), isPacketized)) continue;
            return (TBuffer)local;
        }
        return null;
    }

    public TBuffer[] getBuffers() {
        return (MediaBuffer[])((Collection)this.__buffers).getValues();
    }

    public long[] getContributingSources() {
        return this._contributingSources;
    }

    public double getDuration() {
        return this._duration;
    }

    public TBuffer getLastBuffer() {
        return (TBuffer)((MediaBuffer[])((Collection)this.__buffers).getValues())[ArrayExtensions.getLength(((Collection)this.__buffers).getValues()) - 1];
    }

    public long getRtpSequenceNumber() {
        return this._rtpSequenceNumber;
    }

    public long getRtpTimestamp() {
        return this._rtpTimestamp;
    }

    public long getSequenceNumber() {
        return this._sequenceNumber;
    }

    public long getSynchronizationSource() {
        return this.__synchronizationSource;
    }

    public long getTimestamp() {
        return this._timestamp;
    }

    public boolean hasBuffer(TFormat format) {
        return this.getBuffer(format) != null;
    }

    public boolean hasBuffer(TFormat format, String sourceId) {
        return this.getBuffer(format, sourceId) != null;
    }

    public MediaFrame(double duration, TBuffer buffer) {
        this(duration);
        this.addBuffer(buffer);
    }

    public MediaFrame(double duration, TBuffer[] buffers) {
        this(duration);
        this.addBuffers((MediaBuffer[])buffers);
    }

    public MediaFrame(double duration) {
        this.setDuration(duration);
        this.setTimestamp(-1L);
        this.setSequenceNumber(-1L);
        this.__buffers = this.createMediaBufferCollection();
    }

    public void removeBuffer(TBuffer buffer) {
        ((Collection)this.__buffers).remove(buffer);
    }

    public void removeBuffers() {
        ((Collection)this.__buffers).removeAll();
    }

    public void removeBuffers(TBuffer[] buffers) {
        ((Collection)this.__buffers).removeMany(buffers);
    }

    public void setBuffer(TBuffer value) {
        ((Collection)this.__buffers).setValue(value);
    }

    public void setBuffers(TBuffer[] value) {
        ((Collection)this.__buffers).replace(value);
    }

    public void setContributingSources(long[] value) {
        this._contributingSources = value;
    }

    public void setDuration(double value) {
        this._duration = value;
    }

    public void setRtpSequenceNumber(long value) {
        this._rtpSequenceNumber = value;
    }

    public void setRtpTimestamp(long value) {
        this._rtpTimestamp = value;
    }

    public void setSequenceNumber(long value) {
        this._sequenceNumber = value;
    }

    public void setSynchronizationSource(long value) {
        this.__synchronizationSource = value;
    }

    public void setTimestamp(long value) {
        this._timestamp = value;
    }
}

