/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.AddressType;
import fm.icelink.DatagramSocket;
import fm.icelink.DatagramSocketCreateArgs;
import fm.icelink.IFunction1;
import fm.icelink.IceGatherPolicy;
import fm.icelink.IcePortRange;
import fm.icelink.IceServer;
import fm.icelink.StreamSocket;
import fm.icelink.StreamSocketCreateArgs;
import fm.icelink.Utility;

class IceGatherOptions {
    private AddressType[] __addressTypes;
    private IceGatherPolicy __policy;
    private IcePortRange __portRange;
    private IceServer[] __servers;
    private int __stunBindingRequestLimit;
    private int __stunRequestTimeout;
    private int __tcpConnectTimeout;
    private int __turnAllocateRequestLimit;
    private static int __unset = -1;
    private IFunction1<DatagramSocketCreateArgs, DatagramSocket> _createDatagramSocket;
    private IFunction1<StreamSocketCreateArgs, StreamSocket> _createStreamSocket;
    private String[] _privateIPAddresses;
    private String[] _publicIPAddresses;

    public AddressType[] getAddressTypes() {
        return this.__addressTypes;
    }

    public IFunction1<DatagramSocketCreateArgs, DatagramSocket> getCreateDatagramSocket() {
        return this._createDatagramSocket;
    }

    public IFunction1<StreamSocketCreateArgs, StreamSocket> getCreateStreamSocket() {
        return this._createStreamSocket;
    }

    public IceGatherPolicy getPolicy() {
        return this.__policy;
    }

    public IcePortRange getPortRange() {
        return this.__portRange;
    }

    public String[] getPrivateIPAddresses() {
        return this._privateIPAddresses;
    }

    public String[] getPublicIPAddresses() {
        return this._publicIPAddresses;
    }

    public IceServer getServer() {
        return Utility.firstOrDefault(this.__servers);
    }

    public IceServer[] getServers() {
        return this.__servers;
    }

    public int getStunBindingRequestLimit() {
        return this.__stunBindingRequestLimit;
    }

    public int getStunRequestTimeout() {
        return this.__stunRequestTimeout;
    }

    public int getTcpConnectTimeout() {
        return this.__tcpConnectTimeout;
    }

    public int getTurnAllocateRequestLimit() {
        return this.__turnAllocateRequestLimit;
    }

    public IceGatherOptions(IceGatherPolicy policy, IceServer[] servers, IcePortRange portRange, AddressType[] addressTypes, int stunRequestTimeout) {
        this(policy, servers, portRange, addressTypes, stunRequestTimeout, __unset);
    }

    public IceGatherOptions(IceGatherPolicy policy, IceServer[] servers, IcePortRange portRange, AddressType[] addressTypes) {
        this(policy, servers, portRange, addressTypes, __unset);
    }

    public IceGatherOptions(IceGatherPolicy policy, IceServer[] servers, IcePortRange portRange) {
        this(policy, servers, portRange, null);
    }

    public IceGatherOptions(IceGatherPolicy policy, IceServer[] servers, IcePortRange portRange, AddressType[] addressTypes, int stunRequestTimeout, int tcpConnectTimeout, int turnAllocateRequestLimit, int stunBindingRequestLimit) {
        if (servers == null) {
            servers = new IceServer[]{};
        }
        if (portRange == null) {
            portRange = new IcePortRange();
        }
        if (addressTypes == null) {
            addressTypes = new AddressType[]{AddressType.IPv4, AddressType.IPv6};
        }
        if (stunRequestTimeout == __unset) {
            stunRequestTimeout = 3000;
        }
        if (tcpConnectTimeout == __unset) {
            tcpConnectTimeout = 3000;
        }
        if (stunBindingRequestLimit == __unset) {
            stunBindingRequestLimit = 5;
        }
        if (turnAllocateRequestLimit == __unset) {
            turnAllocateRequestLimit = 5;
        }
        this.__policy = policy;
        this.__servers = servers;
        this.__portRange = portRange;
        this.__addressTypes = addressTypes;
        this.__stunRequestTimeout = stunRequestTimeout;
        this.__turnAllocateRequestLimit = turnAllocateRequestLimit;
        this.__tcpConnectTimeout = tcpConnectTimeout;
        this.__stunBindingRequestLimit = stunBindingRequestLimit;
    }

    public IceGatherOptions(IceGatherPolicy policy, IceServer[] servers, IcePortRange portRange, AddressType[] addressTypes, int stunRequestTimeout, int tcpConnectTimeout, int turnAllocateRequestLimit) {
        this(policy, servers, portRange, addressTypes, stunRequestTimeout, tcpConnectTimeout, turnAllocateRequestLimit, __unset);
    }

    public IceGatherOptions(IceGatherPolicy policy, IceServer[] servers, IcePortRange portRange, AddressType[] addressTypes, int stunRequestTimeout, int tcpConnectTimeout) {
        this(policy, servers, portRange, addressTypes, stunRequestTimeout, tcpConnectTimeout, __unset);
    }

    public IceGatherOptions(IceGatherPolicy policy) {
        this(policy, null);
    }

    public IceGatherOptions(IceGatherPolicy policy, IceServer[] servers) {
        this(policy, servers, null);
    }

    public void setCreateDatagramSocket(IFunction1<DatagramSocketCreateArgs, DatagramSocket> value) {
        this._createDatagramSocket = value;
    }

    public void setCreateStreamSocket(IFunction1<StreamSocketCreateArgs, StreamSocket> value) {
        this._createStreamSocket = value;
    }

    public void setPrivateIPAddresses(String[] value) {
        this._privateIPAddresses = value;
    }

    public void setPublicIPAddresses(String[] value) {
        this._publicIPAddresses = value;
    }
}

