/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.DataBuffer;
import fm.icelink.DataChannelBase;
import fm.icelink.DataChannelState;
import fm.icelink.DataChannelStats;
import fm.icelink.DateExtensions;
import fm.icelink.IAction1;
import fm.icelink.IActionDelegate1;
import fm.icelink.ReliableChannel;
import fm.icelink.ReliableChannelState;
import fm.icelink.StringExtensions;

public class DataChannel
extends DataChannelBase<DataChannel> {
    private ReliableChannel _innerDataChannel;

    void clean() {
        super.setState(DataChannelState.Closed);
        this.getInnerDataChannel().removeOnStateChange((IAction1<ReliableChannel>)new IActionDelegate1<ReliableChannel>(){

            @Override
            public String getId() {
                return "fm.icelink.DataChannel.processInnerChannelStateChange";
            }

            @Override
            public void invoke(ReliableChannel channel) {
                DataChannel.this.processInnerChannelStateChange(channel);
            }
        });
        this.getInnerDataChannel().removeOnReceiveBinary((IAction1<DataBuffer>)new IActionDelegate1<DataBuffer>(){

            @Override
            public String getId() {
                return "fm.icelink.DataChannelBase<fm.icelink.DataChannel>.raiseDataBytes";
            }

            @Override
            public void invoke(DataBuffer dataBytes) {
                DataChannel.this.raiseDataBytes(dataBytes);
            }
        });
        this.getInnerDataChannel().removeOnReceiveString((IAction1<String>)new IActionDelegate1<String>(){

            @Override
            public String getId() {
                return "fm.icelink.DataChannelBase<fm.icelink.DataChannel>.raiseDataString";
            }

            @Override
            public void invoke(String dataString) {
                DataChannel.this.raiseDataString(dataString);
            }
        });
        this.setInnerDataChannel(null);
    }

    public DataChannel(String label, boolean ordered) {
        this(label, ordered, StringExtensions.empty);
    }

    public DataChannel(String label, boolean ordered, String subprotocol) {
        super(label, ordered, subprotocol);
        this.setInnerDataChannel(new ReliableChannel(label, ordered, subprotocol));
        this.getInnerDataChannel().removeOnReceiveBinary((IAction1<DataBuffer>)new IActionDelegate1<DataBuffer>(){

            @Override
            public String getId() {
                return "fm.icelink.DataChannelBase<fm.icelink.DataChannel>.raiseDataBytes";
            }

            @Override
            public void invoke(DataBuffer dataBytes) {
                DataChannel.this.raiseDataBytes(dataBytes);
            }
        });
        this.getInnerDataChannel().addOnReceiveBinary((IAction1<DataBuffer>)new IActionDelegate1<DataBuffer>(){

            @Override
            public String getId() {
                return "fm.icelink.DataChannelBase<fm.icelink.DataChannel>.raiseDataBytes";
            }

            @Override
            public void invoke(DataBuffer dataBytes) {
                DataChannel.this.raiseDataBytes(dataBytes);
            }
        });
        this.getInnerDataChannel().removeOnReceiveString((IAction1<String>)new IActionDelegate1<String>(){

            @Override
            public String getId() {
                return "fm.icelink.DataChannelBase<fm.icelink.DataChannel>.raiseDataString";
            }

            @Override
            public void invoke(String dataString) {
                DataChannel.this.raiseDataString(dataString);
            }
        });
        this.getInnerDataChannel().addOnReceiveString((IAction1<String>)new IActionDelegate1<String>(){

            @Override
            public String getId() {
                return "fm.icelink.DataChannelBase<fm.icelink.DataChannel>.raiseDataString";
            }

            @Override
            public void invoke(String dataString) {
                DataChannel.this.raiseDataString(dataString);
            }
        });
        this.getInnerDataChannel().removeOnStateChange((IAction1<ReliableChannel>)new IActionDelegate1<ReliableChannel>(){

            @Override
            public String getId() {
                return "fm.icelink.DataChannel.processInnerChannelStateChange";
            }

            @Override
            public void invoke(ReliableChannel channel) {
                DataChannel.this.processInnerChannelStateChange(channel);
            }
        });
        this.getInnerDataChannel().addOnStateChange((IAction1<ReliableChannel>)new IActionDelegate1<ReliableChannel>(){

            @Override
            public String getId() {
                return "fm.icelink.DataChannel.processInnerChannelStateChange";
            }

            @Override
            public void invoke(ReliableChannel channel) {
                DataChannel.this.processInnerChannelStateChange(channel);
            }
        });
    }

    public DataChannel(String label) {
        this(label, true);
    }

    ReliableChannel getInnerDataChannel() {
        return this._innerDataChannel;
    }

    @Override
    protected DataChannel getInstance() {
        return this;
    }

    DataChannelStats getStats() {
        ReliableChannel innerDataChannel = this.getInnerDataChannel();
        DataChannelStats stats = new DataChannelStats();
        stats.setId(super.getId());
        stats.setTimestamp(DateExtensions.getUtcNow());
        stats.setLabel(super.getLabel());
        stats.setOrdered(super.getOrdered());
        stats.setProtocol(super.getSubprotocol());
        stats.setState(super.getState());
        stats.setBytesSent(innerDataChannel == null ? 0L : innerDataChannel.getBytesSent());
        stats.setMessagesSent(innerDataChannel == null ? 0L : innerDataChannel.getMessagesSent());
        stats.setBytesReceived(innerDataChannel == null ? 0L : innerDataChannel.getBytesReceived());
        stats.setMessagesReceived(innerDataChannel == null ? 0L : innerDataChannel.getMessagesReceived());
        return stats;
    }

    private void processInnerChannelStateChange(ReliableChannel channel) {
        ReliableChannelState _var0 = channel.getState();
        if (_var0 == ReliableChannelState.Opening) {
            super.setState(DataChannelState.Connecting);
        } else if (_var0 == ReliableChannelState.Open) {
            super.setState(DataChannelState.Connected);
        } else if (_var0 == ReliableChannelState.Closing) {
            super.setState(DataChannelState.Closing);
        } else if (_var0 == ReliableChannelState.Closed) {
            super.setState(DataChannelState.Closed);
        } else if (_var0 == ReliableChannelState.Failed) {
            super.setState(DataChannelState.Failed);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reset() {
        Object object = this._stateLock;
        synchronized (object) {
            super.setState(DataChannelState.New);
            this.setInnerDataChannel(new ReliableChannel(super.getLabel(), super.getOrdered(), super.getSubprotocol()));
            this.getInnerDataChannel().removeOnReceiveBinary((IAction1<DataBuffer>)new IActionDelegate1<DataBuffer>(){

                @Override
                public String getId() {
                    return "fm.icelink.DataChannelBase<fm.icelink.DataChannel>.raiseDataBytes";
                }

                @Override
                public void invoke(DataBuffer dataBytes) {
                    DataChannel.this.raiseDataBytes(dataBytes);
                }
            });
            this.getInnerDataChannel().addOnReceiveBinary((IAction1<DataBuffer>)new IActionDelegate1<DataBuffer>(){

                @Override
                public String getId() {
                    return "fm.icelink.DataChannelBase<fm.icelink.DataChannel>.raiseDataBytes";
                }

                @Override
                public void invoke(DataBuffer dataBytes) {
                    DataChannel.this.raiseDataBytes(dataBytes);
                }
            });
            this.getInnerDataChannel().removeOnReceiveString((IAction1<String>)new IActionDelegate1<String>(){

                @Override
                public String getId() {
                    return "fm.icelink.DataChannelBase<fm.icelink.DataChannel>.raiseDataString";
                }

                @Override
                public void invoke(String dataString) {
                    DataChannel.this.raiseDataString(dataString);
                }
            });
            this.getInnerDataChannel().addOnReceiveString((IAction1<String>)new IActionDelegate1<String>(){

                @Override
                public String getId() {
                    return "fm.icelink.DataChannelBase<fm.icelink.DataChannel>.raiseDataString";
                }

                @Override
                public void invoke(String dataString) {
                    DataChannel.this.raiseDataString(dataString);
                }
            });
            this.getInnerDataChannel().removeOnStateChange((IAction1<ReliableChannel>)new IActionDelegate1<ReliableChannel>(){

                @Override
                public String getId() {
                    return "fm.icelink.DataChannel.processInnerChannelStateChange";
                }

                @Override
                public void invoke(ReliableChannel channel) {
                    DataChannel.this.processInnerChannelStateChange(channel);
                }
            });
            this.getInnerDataChannel().addOnStateChange((IAction1<ReliableChannel>)new IActionDelegate1<ReliableChannel>(){

                @Override
                public String getId() {
                    return "fm.icelink.DataChannel.processInnerChannelStateChange";
                }

                @Override
                public void invoke(ReliableChannel channel) {
                    DataChannel.this.processInnerChannelStateChange(channel);
                }
            });
        }
    }

    @Override
    public void sendDataBytes(DataBuffer dataBytes) {
        ReliableChannel innerDataChannel = this.getInnerDataChannel();
        if (innerDataChannel != null) {
            innerDataChannel.sendBytes(dataBytes);
        }
    }

    @Override
    public void sendDataString(String dataString) {
        ReliableChannel innerDataChannel = this.getInnerDataChannel();
        if (innerDataChannel != null) {
            innerDataChannel.sendString(dataString);
        }
    }

    void setInnerDataChannel(ReliableChannel value) {
        this._innerDataChannel = value;
    }
}

