/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.audioprocessing;

import fm.icelink.AudioBuffer;
import fm.icelink.AudioFormat;
import fm.icelink.AudioFrame;
import fm.icelink.DataBuffer;
import fm.icelink.DataBufferPool;
import fm.icelink.Global;
import fm.icelink.Log;
import java.util.HashMap;

class Native
extends fm.icelink.Native {
    private long _state;
    static HashMap<Integer, DataBuffer> allocMap;

    public Native(int clockRate, int channelCount) {
        this._state = Native.AudioProcessingFMCreate(0L, 0L, 0L, 0L, clockRate, channelCount, true);
    }

    public void destroy() {
        Native.AudioProcessingFMDestroy(this._state);
        this._state = 0L;
    }

    public AudioBuffer capture(AudioFrame frame, AudioBuffer inputBuffer, AudioFormat outputFormat, int tailLength) {
        DataBuffer inputDataBuffer = inputBuffer.getDataBuffer();
        byte[] outputData = Native.AudioProcessingFMProcessStream(this._state, inputDataBuffer.getData(), inputDataBuffer.getIndex(), inputDataBuffer.getLength(), tailLength);
        if (outputData != null) {
            DataBuffer outputDataBuffer = Native.getBuffer(outputData);
            outputDataBuffer.setLittleEndian(inputDataBuffer.getLittleEndian());
            return new AudioBuffer(outputDataBuffer, outputFormat);
        }
        return null;
    }

    public void render(AudioFrame frame) {
        AudioBuffer audioBuffer = ((AudioBuffer[])frame.getBuffers())[((AudioBuffer[])frame.getBuffers()).length - 1];
        DataBuffer pcm = audioBuffer.getDataBuffer();
        Native.AudioProcessingFMProcessReverseStream(this._state, pcm.getData(), pcm.getIndex(), pcm.getLength());
    }

    private static void DebugCallback(String msg) {
        Log.info((String)("LibAudioProcessingFM: " + msg));
    }

    private static void ErrorCallback(String msg) {
        Log.error((String)("LibAudioProcessingFM: " + msg));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] AllocCallback(int size) {
        HashMap<Integer, DataBuffer> hashMap = allocMap;
        synchronized (hashMap) {
            DataBuffer buffer = DataBufferPool.getInstance().take(size);
            byte[] data = buffer.getData();
            allocMap.put(data.hashCode(), buffer);
            return data;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DataBuffer getBuffer(byte[] data) {
        HashMap<Integer, DataBuffer> hashMap = allocMap;
        synchronized (hashMap) {
            DataBuffer buffer = allocMap.remove(data.hashCode());
            return buffer;
        }
    }

    private static native long AudioProcessingFMCreate(long var0, long var2, long var4, long var6, int var8, int var9, boolean var10);

    private static native void AudioProcessingFMDestroy(long var0);

    private static native void AudioProcessingFMProcessReverseStream(long var0, byte[] var2, int var3, int var4);

    private static native byte[] AudioProcessingFMProcessStream(long var0, byte[] var2, int var3, int var4, int var5);

    static {
        Global.loadLibrary((String)"audioprocessingfmJNI");
        allocMap = new HashMap();
    }
}

