/*
 * Decompiled with CFR 0.152.
 */
package fm.websync;

import fm.Crypto;
import fm.Guid;
import fm.Holder;
import fm.NullableGuid;
import fm.Serializer;
import fm.SingleAction;
import fm.websync.BaseInputArgs;
import fm.websync.NotifyCompleteArgs;
import fm.websync.NotifyFailureArgs;
import fm.websync.NotifySuccessArgs;

public class NotifyArgs
extends BaseInputArgs {
    byte[] __dataBytes;
    String __dataJson;
    private SingleAction<NotifyCompleteArgs> _onComplete;
    private SingleAction<NotifyFailureArgs> _onFailure;
    private SingleAction<NotifySuccessArgs> _onSuccess;

    public Guid getClientId() throws Exception {
        NullableGuid nullable = Serializer.deserializeGuid((String)super.getExtensionValueJson("fm.notify"));
        if (nullable.getHasValue()) {
            return nullable.getValue();
        }
        return Guid.empty;
    }

    public byte[] getDataBytes() throws Exception {
        byte[] decoded = this.__dataBytes;
        String valueJson = this.__dataJson;
        if (decoded != null) {
            return decoded;
        }
        if (valueJson != null) {
            Holder _var0 = new Holder((Object)decoded);
            boolean _var1 = Crypto.tryBase64Decode((String)Serializer.deserializeString((String)valueJson), (Holder)_var0);
            decoded = (byte[])_var0.getValue();
            if (!_var1) {
                decoded = null;
            }
            this.__dataBytes = decoded;
            return decoded;
        }
        return null;
    }

    public String getDataJson() {
        String str = this.__dataJson;
        byte[] b = this.__dataBytes;
        if (str != null) {
            return str;
        }
        if (b != null) {
            this.__dataJson = str = Serializer.serializeString((String)Crypto.base64Encode((byte[])b));
            return str;
        }
        return null;
    }

    public boolean getIsBinary() throws Exception {
        return this.getDataBytes() != null;
    }

    public SingleAction<NotifyCompleteArgs> getOnComplete() {
        return this._onComplete;
    }

    public SingleAction<NotifyFailureArgs> getOnFailure() {
        return this._onFailure;
    }

    public SingleAction<NotifySuccessArgs> getOnSuccess() {
        return this._onSuccess;
    }

    public String getTag() throws Exception {
        return Serializer.deserializeString((String)super.getExtensionValueJson("fm.tag"));
    }

    public NotifyArgs(Guid clientId, byte[] dataBytes, String tag) throws Exception {
        this.setClientId(clientId);
        this.setDataBytes(dataBytes);
        this.setTag(tag);
    }

    public NotifyArgs(Guid clientId, String dataJson) throws Exception {
        this(clientId, dataJson, null);
    }

    public NotifyArgs(Guid clientId, byte[] dataBytes) throws Exception {
        this(clientId, dataBytes, null);
    }

    public NotifyArgs(Guid clientId, String dataJson, String tag) throws Exception {
        this.setClientId(clientId);
        this.setDataJson(dataJson);
        this.setTag(tag);
    }

    public void setClientId(Guid value) throws Exception {
        super.setExtensionValueJson("fm.notify", Serializer.serializeGuid((NullableGuid)new NullableGuid(value)), false);
    }

    public void setDataBytes(byte[] value) {
        this.__dataJson = null;
        this.__dataBytes = value;
    }

    public void setDataJson(String value) throws Exception {
        if (value != null && !Serializer.isValidJson((String)value)) {
            throw new Exception("The value is not valid JSON.");
        }
        this.__dataJson = value;
        this.__dataBytes = null;
    }

    public void setOnComplete(SingleAction<NotifyCompleteArgs> value) {
        this._onComplete = value;
    }

    public void setOnFailure(SingleAction<NotifyFailureArgs> value) {
        this._onFailure = value;
    }

    public void setOnSuccess(SingleAction<NotifySuccessArgs> value) {
        this._onSuccess = value;
    }

    public void setTag(String value) throws Exception {
        super.setExtensionValueJson("fm.tag", Serializer.serializeString((String)value), false);
    }
}

