/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.stun.turn;

import fm.icelink.DataBuffer;
import fm.icelink.StringExtensions;
import fm.icelink.stun.Attribute;

public class ReservationTokenAttribute
extends Attribute {
    private DataBuffer _token;

    public DataBuffer getToken() {
        return this._token;
    }

    @Override
    public int getTypeValue() {
        return Attribute.getReservationTokenType();
    }

    @Override
    protected int getValueLength() {
        return 8;
    }

    public static ReservationTokenAttribute readValueFrom(DataBuffer buffer, int offset) {
        return new ReservationTokenAttribute(buffer.subset(offset, 8));
    }

    public ReservationTokenAttribute(DataBuffer token) {
        if (token.getLength() != 8) {
            throw new RuntimeException(new Exception("token must be 8 bytes."));
        }
        this.setToken(token);
    }

    public void setToken(DataBuffer value) {
        this._token = value;
    }

    public String toString() {
        return StringExtensions.format("RESERVATION-TOKEN {0}", this.getToken().toHexString());
    }

    @Override
    protected void writeValueTo(DataBuffer buffer, int offset) {
        buffer.write(this.getToken(), offset);
    }
}

