/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.stun;

import fm.icelink.DataBuffer;
import fm.icelink.IntegerExtensions;
import fm.icelink.StringExtensions;
import fm.icelink.stun.Attribute;

public class TransactionTransmitCounterAttribute
extends Attribute {
    private int _numRequests;
    private int _numResponses;

    public int getNumRequests() {
        return this._numRequests;
    }

    public int getNumResponses() {
        return this._numResponses;
    }

    @Override
    public int getTypeValue() {
        return Attribute.getTransactionTransmitCounterType();
    }

    @Override
    protected int getValueLength() {
        return 4;
    }

    public static TransactionTransmitCounterAttribute readValueFrom(DataBuffer buffer, int offset) {
        int numRequests = buffer.read8(offset + 2);
        return new TransactionTransmitCounterAttribute(numRequests, buffer.read8(offset + 3));
    }

    public void setNumRequests(int value) {
        this._numRequests = value;
    }

    public void setNumResponses(int value) {
        this._numResponses = value;
    }

    public String toString() {
        if (this.getNumResponses() < 1) {
            return StringExtensions.format("TRANSACTION-TRANSMIT-COUNTER Requests: {0}", IntegerExtensions.toString(this.getNumRequests()));
        }
        return StringExtensions.format("TRANSACTION-TRANSMIT-COUNTER Requests: {0}, Responses: {1}", IntegerExtensions.toString(this.getNumRequests()), IntegerExtensions.toString(this.getNumResponses()));
    }

    public TransactionTransmitCounterAttribute(int numRequests, int numResponses) {
        this.setNumRequests(numRequests);
        this.setNumResponses(numResponses);
    }

    public TransactionTransmitCounterAttribute(int numRequests) {
        this(numRequests, 0);
    }

    @Override
    protected void writeValueTo(DataBuffer buffer, int offset) {
        buffer.write16(0, offset);
        buffer.write8(this.getNumRequests(), offset + 2);
        buffer.write8(this.getNumResponses(), offset + 3);
    }
}

