/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.stun;

import fm.icelink.AddressType;
import fm.icelink.DataBuffer;
import fm.icelink.Global;
import fm.icelink.IntegerExtensions;
import fm.icelink.LocalNetwork;
import fm.icelink.StringExtensions;
import fm.icelink.TransportAddress;
import fm.icelink.stun.Attribute;

public class AlternateServerAttribute
extends Attribute {
    private String _ipAddress;
    private int _port;

    public AlternateServerAttribute(String ipAddress, int port) {
        this.setIPAddress(TransportAddress.sanitizeIPAddress(ipAddress));
        this.setPort(port);
    }

    private AlternateServerAttribute() {
    }

    public String getIPAddress() {
        return this._ipAddress;
    }

    public int getPort() {
        return this._port;
    }

    @Override
    public int getTypeValue() {
        return Attribute.getAlternateServerType();
    }

    @Override
    protected int getValueLength() {
        if (Global.equals((Object)LocalNetwork.getAddressType(this.getIPAddress()), (Object)AddressType.IPv4)) {
            return 8;
        }
        return 20;
    }

    public static AlternateServerAttribute readValueFrom(DataBuffer buffer, int offset) {
        AddressType addressType = Attribute.readAddressType(buffer, offset + 1);
        if (Global.equals((Object)addressType, (Object)AddressType.getByAssignedValue(0))) {
            return null;
        }
        AlternateServerAttribute attribute = new AlternateServerAttribute();
        attribute.setPort(Attribute.readPort(buffer, offset + 2));
        attribute.setIPAddress(Attribute.readIPAddress(buffer, offset + 4, addressType));
        return attribute;
    }

    public void setIPAddress(String value) {
        this._ipAddress = value;
    }

    public void setPort(int value) {
        this._port = value;
    }

    public String toString() {
        return StringExtensions.format("ALTERNATE-SERVER {0}:{1}", this.getIPAddress(), IntegerExtensions.toString(this.getPort()));
    }

    @Override
    protected void writeValueTo(DataBuffer buffer, int offset) {
        AddressType addressType = LocalNetwork.getAddressType(this.getIPAddress());
        buffer.write8(0, offset);
        Attribute.writeAddressType(buffer, offset + 1, addressType);
        super.writePort(buffer, offset + 2, this.getPort());
        super.writeIPAddress(buffer, offset + 4, addressType, this.getIPAddress());
    }
}

