/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.matroska;

import fm.icelink.ArrayExtensions;
import fm.icelink.BitAssistant;
import fm.icelink.ByteOutputStream;
import fm.icelink.Global;
import fm.icelink.IntegerHolder;
import fm.icelink.Log;
import fm.icelink.StringExtensions;
import fm.icelink.matroska.Element;

public class Ebml
extends Element {
    private String _docType;
    private static byte[] _docTypeId;
    private long _docTypeReadVersion;
    private static byte[] _docTypeReadVersionId;
    private long _docTypeVersion;
    private static byte[] _docTypeVersionId;
    private long _ebmlMaxIdLength;
    private static byte[] _ebmlMaxIdLengthId;
    private long _ebmlMaxSizeLength;
    private static byte[] _ebmlMaxSizeLengthId;
    private long _ebmlReadVersion;
    private static byte[] _ebmlReadVersionId;
    private long _ebmlVersion;
    private static byte[] _ebmlVersionId;

    public Ebml() {
        this.setEbmlVersion(Ebml.getDefaultEbmlVersion());
        this.setEbmlReadVersion(Ebml.getDefaultEbmlReadVersion());
        this.setEbmlMaxIdLength(Ebml.getDefaultEbmlMaxIdLength());
        this.setEbmlMaxSizeLength(Ebml.getDefaultEbmlMaxSizeLength());
        this.setDocType(Ebml.getDefaultDocType());
        this.setDocTypeVersion(Ebml.getDefaultDocTypeVersion());
        this.setDocTypeReadVersion(Ebml.getDefaultDocTypeReadVersion());
    }

    public Ebml(byte[] bytes) {
        this();
        int offset = 0;
        while (offset < ArrayExtensions.getLength(bytes)) {
            IntegerHolder _var0 = new IntegerHolder(offset);
            byte[] _var1 = Element.readId(bytes, offset, _var0);
            offset = _var0.getValue();
            byte[] buffer = _var1;
            IntegerHolder _var2 = new IntegerHolder(offset);
            byte[] _var3 = Element.readValue(bytes, offset, _var2);
            offset = _var2.getValue();
            byte[] buffer2 = _var3;
            if (Element.compare(buffer, _ebmlVersionId)) {
                this.setEbmlVersion(Element.readUnsignedInteger(buffer2));
                continue;
            }
            if (Element.compare(buffer, _ebmlReadVersionId)) {
                this.setEbmlReadVersion(Element.readUnsignedInteger(buffer2));
                continue;
            }
            if (Element.compare(buffer, _ebmlMaxIdLengthId)) {
                this.setEbmlMaxIdLength(Element.readUnsignedInteger(buffer2));
                continue;
            }
            if (Element.compare(buffer, _ebmlMaxSizeLengthId)) {
                this.setEbmlMaxSizeLength(Element.readUnsignedInteger(buffer2));
                continue;
            }
            if (Element.compare(buffer, _docTypeId)) {
                this.setDocType(Element.readString(buffer2));
                continue;
            }
            if (Element.compare(buffer, _docTypeVersionId)) {
                this.setDocTypeVersion(Element.readUnsignedInteger(buffer2));
                continue;
            }
            if (Element.compare(buffer, _docTypeReadVersionId)) {
                this.setDocTypeReadVersion(Element.readUnsignedInteger(buffer2));
                continue;
            }
            Log.warn(StringExtensions.concat("Unrecognized ID in MatroskaEbml: ", BitAssistant.getHexString(buffer)));
        }
    }

    public static String getDefaultDocType() {
        return "matroska";
    }

    public static long getDefaultDocTypeReadVersion() {
        return 1L;
    }

    public static long getDefaultDocTypeVersion() {
        return 1L;
    }

    public static long getDefaultEbmlMaxIdLength() {
        return 4L;
    }

    public static long getDefaultEbmlMaxSizeLength() {
        return 8L;
    }

    public static long getDefaultEbmlReadVersion() {
        return 1L;
    }

    public static long getDefaultEbmlVersion() {
        return 1L;
    }

    public String getDocType() {
        return this._docType;
    }

    public long getDocTypeReadVersion() {
        return this._docTypeReadVersion;
    }

    public long getDocTypeVersion() {
        return this._docTypeVersion;
    }

    public static byte[] getEbmlId() {
        return new byte[]{26, 69, -33, -93};
    }

    public long getEbmlMaxIdLength() {
        return this._ebmlMaxIdLength;
    }

    public long getEbmlMaxSizeLength() {
        return this._ebmlMaxSizeLength;
    }

    public long getEbmlReadVersion() {
        return this._ebmlReadVersion;
    }

    public long getEbmlVersion() {
        return this._ebmlVersion;
    }

    @Override
    public byte[] getId() {
        return Ebml.getEbmlId();
    }

    @Override
    protected byte[] getInnerBytes() {
        ByteOutputStream stream = new ByteOutputStream();
        if (super.getWriteDefaultValues() || this.getEbmlVersion() != Ebml.getDefaultEbmlVersion()) {
            super.writeUnsignedInteger(this.getEbmlVersion(), _ebmlVersionId, stream);
        }
        if (super.getWriteDefaultValues() || this.getEbmlReadVersion() != Ebml.getDefaultEbmlReadVersion()) {
            super.writeUnsignedInteger(this.getEbmlReadVersion(), _ebmlReadVersionId, stream);
        }
        if (super.getWriteDefaultValues() || this.getEbmlMaxIdLength() != Ebml.getDefaultEbmlMaxIdLength()) {
            super.writeUnsignedInteger(this.getEbmlMaxIdLength(), _ebmlMaxIdLengthId, stream);
        }
        if (super.getWriteDefaultValues() || this.getEbmlMaxSizeLength() != Ebml.getDefaultEbmlMaxSizeLength()) {
            super.writeUnsignedInteger(this.getEbmlMaxSizeLength(), _ebmlMaxSizeLengthId, stream);
        }
        if ((super.getWriteDefaultValues() || !Global.equals(this.getDocType(), Ebml.getDefaultDocType())) && this.getDocType() != null) {
            super.writeString(this.getDocType(), _docTypeId, stream);
        }
        if (super.getWriteDefaultValues() || this.getDocTypeVersion() != Ebml.getDefaultDocTypeVersion()) {
            super.writeUnsignedInteger(this.getDocTypeVersion(), _docTypeVersionId, stream);
        }
        if (super.getWriteDefaultValues() || this.getDocTypeReadVersion() != Ebml.getDefaultDocTypeReadVersion()) {
            super.writeUnsignedInteger(this.getDocTypeReadVersion(), _docTypeReadVersionId, stream);
        }
        return stream.toArray();
    }

    public void merge(Ebml ebml) {
        if (ebml != null) {
            // empty if block
        }
    }

    public void setDocType(String value) {
        this._docType = value;
    }

    public void setDocTypeReadVersion(long value) {
        this._docTypeReadVersion = value;
    }

    public void setDocTypeVersion(long value) {
        this._docTypeVersion = value;
    }

    public void setEbmlMaxIdLength(long value) {
        this._ebmlMaxIdLength = value;
    }

    public void setEbmlMaxSizeLength(long value) {
        this._ebmlMaxSizeLength = value;
    }

    public void setEbmlReadVersion(long value) {
        this._ebmlReadVersion = value;
    }

    public void setEbmlVersion(long value) {
        this._ebmlVersion = value;
    }

    static {
        _ebmlVersionId = new byte[]{66, -122};
        _ebmlReadVersionId = new byte[]{66, -9};
        _ebmlMaxIdLengthId = new byte[]{66, -14};
        _ebmlMaxSizeLengthId = new byte[]{66, -13};
        _docTypeId = new byte[]{66, -126};
        _docTypeVersionId = new byte[]{66, -121};
        _docTypeReadVersionId = new byte[]{66, -123};
    }
}

