/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.BaseStats;
import fm.icelink.Global;
import fm.icelink.HashMapExtensions;
import fm.icelink.JsonSerializer;
import fm.icelink.StreamType;
import fm.icelink.TransportStats;
import java.util.HashMap;

public abstract class StreamStats
extends BaseStats {
    private TransportStats _transport;
    private StreamType _type;

    @Override
    protected void deserializeProperties(String key, String valueJson) {
        super.deserializeProperties(key, valueJson);
        String str = key;
        if (str != null) {
            if (!Global.equals(str, "type")) {
                if (Global.equals(str, "transport")) {
                    this.setTransport(TransportStats.fromJson(valueJson));
                }
            } else {
                this.setType(this.typeFromString(JsonSerializer.deserializeString(valueJson)));
            }
        }
    }

    public boolean getIsHost() {
        TransportStats transport = this.getTransport();
        if (transport == null) {
            return false;
        }
        return transport.getIsHost();
    }

    public boolean getIsReflexive() {
        TransportStats transport = this.getTransport();
        if (transport == null) {
            return false;
        }
        return transport.getIsReflexive();
    }

    public boolean getIsRelayed() {
        TransportStats transport = this.getTransport();
        if (transport == null) {
            return false;
        }
        return transport.getIsRelayed();
    }

    public TransportStats getTransport() {
        return this._transport;
    }

    public StreamType getType() {
        return this._type;
    }

    @Override
    protected void serializeProperties(HashMap<String, String> jsonObject) {
        super.serializeProperties(jsonObject);
        HashMapExtensions.set(HashMapExtensions.getItem(jsonObject), "type", JsonSerializer.serializeString(this.typeToString(this.getType())));
        if (this.getTransport() != null) {
            HashMapExtensions.set(HashMapExtensions.getItem(jsonObject), "transport", TransportStats.toJson(this.getTransport()));
        }
    }

    void setTransport(TransportStats value) {
        this._transport = value;
    }

    void setType(StreamType value) {
        this._type = value;
    }

    protected StreamStats() {
    }

    private StreamType typeFromString(String typeString) {
        String _var0 = typeString;
        if (_var0.equals("audio")) {
            return StreamType.Audio;
        }
        if (_var0.equals("video")) {
            return StreamType.Video;
        }
        if (_var0.equals("application")) {
            return StreamType.Application;
        }
        if (_var0.equals("message")) {
            return StreamType.Message;
        }
        if (_var0.equals("text")) {
            return StreamType.Text;
        }
        return StreamType.Text;
    }

    private String typeToString(StreamType type) {
        StreamType _var0 = type;
        if (_var0 == StreamType.Audio) {
            return "audio";
        }
        if (_var0 == StreamType.Video) {
            return "video";
        }
        if (_var0 == StreamType.Application) {
            return "application";
        }
        if (_var0 == StreamType.Message) {
            return "message";
        }
        if (_var0 == StreamType.Text) {
            return "text";
        }
        return null;
    }
}

