/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayExtensions;
import fm.icelink.Binary;
import fm.icelink.BitAssistant;
import fm.icelink.ByteCollection;
import fm.icelink.IntegerHolder;
import fm.icelink.Log;
import fm.icelink.SctpErrorCause;

class SctpUserInitiatedAbort
extends SctpErrorCause {
    private byte[] _upperLayerAbortReason;

    @Override
    public byte[] getBytes() {
        return SctpUserInitiatedAbort.getBytes(this);
    }

    public static byte[] getBytes(SctpUserInitiatedAbort cause) {
        ByteCollection bytes = new ByteCollection();
        bytes.addRange(Binary.toBytes16(cause.getCauseCode(), false));
        if (cause.getUpperLayerAbortReason() != null) {
            bytes.addRange(cause.getUpperLayerAbortReason());
        }
        bytes.insertRange(2, Binary.toBytes16(bytes.getCount() + 2, false));
        return bytes.toArray();
    }

    public byte[] getUpperLayerAbortReason() {
        return this._upperLayerAbortReason;
    }

    public static SctpUserInitiatedAbort parseBytes(byte[] bytes, IntegerHolder offsetPlus) {
        try {
            int num = Binary.fromBytes16(bytes, 2, false);
            byte[] destination = null;
            Log.debug("SCTP Error: user initiated abort");
            if (num > 4) {
                destination = new byte[num - 4];
                BitAssistant.copy(bytes, 4, destination, 0, ArrayExtensions.getLength(destination));
            }
            offsetPlus.setValue(num);
            return new SctpUserInitiatedAbort(destination);
        }
        catch (Exception exception1) {
            Log.warn("Could not parse User initiated abort");
            offsetPlus.setValue(0);
            return null;
        }
    }

    public SctpUserInitiatedAbort() {
        super.setCauseCode(12);
    }

    public SctpUserInitiatedAbort(byte[] abortReason) {
        super.setCauseCode(12);
        this.setUpperLayerAbortReason(abortReason);
    }

    public void setUpperLayerAbortReason(byte[] value) {
        this._upperLayerAbortReason = value;
    }
}

