/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.Binary;
import fm.icelink.ByteCollection;
import fm.icelink.IntegerHolder;
import fm.icelink.SctpChunkType;
import fm.icelink.SctpControlChunk;

class SctpShutdownCompleteChunk
extends SctpControlChunk {
    private boolean _verificationTagReflected;

    @Override
    public byte[] getBytes() {
        return SctpShutdownCompleteChunk.getBytes(this);
    }

    public static byte[] getBytes(SctpShutdownCompleteChunk chunk) {
        ByteCollection bytes = new ByteCollection();
        bytes.add((byte)chunk.getType());
        bytes.add(chunk.getVerificationTagReflected() ? (byte)1 : 0);
        bytes.insertRange(2, Binary.toBytes16(4, false));
        return bytes.toArray();
    }

    public boolean getVerificationTagReflected() {
        return this._verificationTagReflected;
    }

    public static SctpShutdownCompleteChunk parseBytes(byte[] bytes, IntegerHolder offsetPlus) {
        try {
            boolean verificationTagReflected = bytes[1] == 1;
            offsetPlus.setValue(4);
            return new SctpShutdownCompleteChunk(verificationTagReflected);
        }
        catch (Exception exception1) {
            offsetPlus.setValue(0);
            return null;
        }
    }

    public SctpShutdownCompleteChunk(boolean verificationTagReflected) {
        super.setCanBundleWithDataAndSackChunks(false);
        super.setType(SctpChunkType.getShutdownComplete());
        this.setVerificationTagReflected(verificationTagReflected);
        super.setUnrecognized(false);
    }

    public void setVerificationTagReflected(boolean value) {
        this._verificationTagReflected = value;
    }
}

