/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayExtensions;
import fm.icelink.Binary;
import fm.icelink.ByteCollection;
import fm.icelink.IntegerHolder;
import fm.icelink.Log;
import fm.icelink.SctpErrorCause;
import fm.icelink.SctpTlvParameter;
import java.util.ArrayList;

class SctpRestartOfAnAssociationWithNewAddresses
extends SctpErrorCause {
    private SctpTlvParameter[] _addresses;

    public SctpTlvParameter[] getAddresses() {
        return this._addresses;
    }

    @Override
    public byte[] getBytes() {
        return SctpRestartOfAnAssociationWithNewAddresses.getBytes(this);
    }

    public static byte[] getBytes(SctpRestartOfAnAssociationWithNewAddresses cause) {
        ByteCollection bytes = new ByteCollection();
        bytes.addRange(Binary.toBytes16(cause.getCauseCode(), false));
        for (int i = 0; i < ArrayExtensions.getLength(cause.getAddresses()); ++i) {
            bytes.addRange(cause.getAddresses()[i].getBytes());
        }
        bytes.insertRange(2, Binary.toBytes16(bytes.getCount() + 2, false));
        return bytes.toArray();
    }

    public static SctpRestartOfAnAssociationWithNewAddresses parseBytes(byte[] bytes, IntegerHolder offsetPlus) {
        try {
            int startIndex;
            int num = Binary.fromBytes16(bytes, 2, false);
            ArrayList<SctpTlvParameter> list = new ArrayList<SctpTlvParameter>();
            for (startIndex = 4; startIndex < num; startIndex += offsetPlus.getValue()) {
                SctpTlvParameter _var0;
                SctpTlvParameter item = _var0 = SctpTlvParameter.parseBytes(bytes, startIndex, offsetPlus);
                list.add(item);
            }
            offsetPlus.setValue(startIndex);
            Log.debug("SCTP Error: association restart with a new address.");
            return new SctpRestartOfAnAssociationWithNewAddresses(list.toArray(new SctpTlvParameter[0]));
        }
        catch (Exception exception1) {
            Log.warn("Could not parse RestartOfAnAssociationWithNewAddresses");
            offsetPlus.setValue(0);
            return null;
        }
    }

    public SctpRestartOfAnAssociationWithNewAddresses(SctpTlvParameter[] addresses) {
        super.setCauseCode(11);
        this.setAddresses(addresses);
    }

    public void setAddresses(SctpTlvParameter[] value) {
        this._addresses = value;
    }
}

