/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.Binary;
import fm.icelink.DateExtensions;
import fm.icelink.TimeSpan;
import java.util.Date;

public class NetworkTimeProtocol {
    private static Date _baseTime = new Date();

    public static Date compactNtpToDateTime(long ntp) {
        byte[] buffer = Binary.toBytes32(ntp, false);
        byte[] buffer4 = new byte[4];
        buffer4[2] = buffer[0];
        buffer4[3] = buffer[1];
        byte[] input = buffer4;
        long num = Binary.fromBytes32(input, 0, false);
        buffer4 = new byte[4];
        buffer4[0] = buffer[2];
        buffer4[1] = buffer[3];
        byte[] buffer3 = buffer4;
        long num3 = Binary.fromBytes32(buffer3, 0, false) * 1000L / 0x100000000L;
        return DateExtensions.addMilliseconds(DateExtensions.addSeconds(_baseTime, num), num3);
    }

    public static long dateTimeToCompactNtp(Date dateTime) {
        TimeSpan span = new TimeSpan(DateExtensions.getTicks(dateTime) - DateExtensions.getTicks(_baseTime));
        long totalMilliseconds = (long)span.getTotalMilliseconds();
        long num2 = totalMilliseconds / 1000L;
        long num3 = totalMilliseconds % 1000L;
        long num4 = 0x100000000L * num3 / 1000L;
        byte[] buffer = Binary.toBytes32(num2, false);
        byte[] buffer2 = Binary.toBytes32(num4, false);
        byte[] input = new byte[]{buffer[2], buffer[3], buffer2[0], buffer2[1]};
        return Binary.fromBytes32(input, 0, false);
    }

    public static long dateTimeToNtp(Date dateTime) {
        TimeSpan span = new TimeSpan(DateExtensions.getTicks(dateTime) - DateExtensions.getTicks(_baseTime));
        double totalSeconds = span.getTotalSeconds();
        byte[] buffer = Binary.toBytes32((long)totalSeconds, false);
        byte[] buffer2 = Binary.toBytes32((long)((totalSeconds - (double)((long)totalSeconds)) * 4.294967296E9), false);
        byte[] input = new byte[]{buffer[0], buffer[1], buffer[2], buffer[3], buffer2[0], buffer2[1], buffer2[2], buffer2[3]};
        return Binary.fromBytes64(input, 0, false);
    }

    public static double dateTimeToNtpSeconds(Date dateTime) {
        TimeSpan span = new TimeSpan(DateExtensions.getTicks(dateTime) - DateExtensions.getTicks(_baseTime));
        return (long)span.getTotalSeconds();
    }

    public static long getUtcNow() {
        return NetworkTimeProtocol.dateTimeToNtp(DateExtensions.getUtcNow());
    }

    public static Date ntpSecondsToDateTime(double ntpSeconds) {
        return DateExtensions.addSeconds(_baseTime, ntpSeconds);
    }

    public static Date ntpToDateTime(long ntp) {
        byte[] input = Binary.toBytes64(ntp, false);
        long num = Binary.fromBytes32(input, 0, false);
        long num3 = Binary.fromBytes32(input, 4, false) * 1000L / 0x100000000L;
        return DateExtensions.addMilliseconds(DateExtensions.addSeconds(_baseTime, num), num3);
    }

    static {
        _baseTime = DateExtensions.createDate(1900, 1, 1, 0, 0, 0);
    }
}

