/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.Global;
import fm.icelink.HashMapExtensions;
import fm.icelink.IAction2;
import fm.icelink.IAction3;
import fm.icelink.IFunction0;
import fm.icelink.IFunctionDelegate1;
import fm.icelink.JsonSerializer;
import fm.icelink.MediaReceiverStats;
import fm.icelink.MediaSenderStats;
import fm.icelink.StreamDirection;
import fm.icelink.StreamDirectionHelper;
import fm.icelink.StreamStats;
import java.util.ArrayList;
import java.util.HashMap;

public class MediaStreamStats
extends StreamStats {
    private StreamDirection _direction;
    private MediaReceiverStats _receiver;
    private MediaSenderStats _sender;

    @Override
    protected void deserializeProperties(String key, String valueJson) {
        super.deserializeProperties(key, valueJson);
        String str = key;
        if (str != null) {
            if (!Global.equals(str, "direction")) {
                if (Global.equals(str, "sender")) {
                    this.setSender(MediaSenderStats.fromJson(valueJson));
                } else if (Global.equals(str, "receiver")) {
                    this.setReceiver(MediaReceiverStats.fromJson(valueJson));
                }
            } else {
                this.setDirection(StreamDirectionHelper.directionFromString(JsonSerializer.deserializeString(valueJson)));
            }
        }
    }

    public static MediaStreamStats fromJson(String mediaStreamJson) {
        return JsonSerializer.deserializeObject(mediaStreamJson, new IFunction0<MediaStreamStats>(){

            @Override
            public MediaStreamStats invoke() {
                return new MediaStreamStats();
            }
        }, new IAction3<MediaStreamStats, String, String>(){

            @Override
            public void invoke(MediaStreamStats obj, String key, String valueJson) {
                obj.deserializeProperties(key, valueJson);
            }
        });
    }

    public static MediaStreamStats[] fromJsonArray(String mediaStreamsJson) {
        ArrayList<MediaStreamStats> list = JsonSerializer.deserializeObjectArray(mediaStreamsJson, new IFunctionDelegate1<String, MediaStreamStats>(){

            @Override
            public String getId() {
                return "fm.icelink.MediaStreamStats.fromJson";
            }

            @Override
            public MediaStreamStats invoke(String mediaStreamJson) {
                return MediaStreamStats.fromJson(mediaStreamJson);
            }
        });
        if (list == null) {
            return null;
        }
        return list.toArray(new MediaStreamStats[0]);
    }

    public StreamDirection getDirection() {
        return this._direction;
    }

    public MediaReceiverStats getReceiver() {
        return this._receiver;
    }

    public MediaSenderStats getSender() {
        return this._sender;
    }

    @Override
    protected void serializeProperties(HashMap<String, String> jsonObject) {
        super.serializeProperties(jsonObject);
        HashMapExtensions.set(HashMapExtensions.getItem(jsonObject), "direction", JsonSerializer.serializeString(StreamDirectionHelper.directionToString(this.getDirection())));
        if (this.getSender() != null) {
            HashMapExtensions.set(HashMapExtensions.getItem(jsonObject), "sender", MediaSenderStats.toJson(this.getSender()));
        }
        if (this.getReceiver() != null) {
            HashMapExtensions.set(HashMapExtensions.getItem(jsonObject), "receiver", MediaReceiverStats.toJson(this.getReceiver()));
        }
    }

    void setDirection(StreamDirection value) {
        this._direction = value;
    }

    void setReceiver(MediaReceiverStats value) {
        this._receiver = value;
    }

    void setSender(MediaSenderStats value) {
        this._sender = value;
    }

    public String toJson() {
        return MediaStreamStats.toJson(this);
    }

    public static String toJson(MediaStreamStats mediaStream) {
        return JsonSerializer.serializeObject(mediaStream, new IAction2<MediaStreamStats, HashMap<String, String>>(){

            @Override
            public void invoke(MediaStreamStats obj, HashMap<String, String> jsonObject) {
                obj.serializeProperties(jsonObject);
            }
        });
    }

    public static String toJsonArray(MediaStreamStats[] mediaStreams) {
        return JsonSerializer.serializeObjectArray(mediaStreams, new IFunctionDelegate1<MediaStreamStats, String>(){

            @Override
            public String getId() {
                return "fm.icelink.MediaStreamStats.toJson";
            }

            @Override
            public String invoke(MediaStreamStats mediaStream) {
                return MediaStreamStats.toJson(mediaStream);
            }
        });
    }
}

