/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.FileAssistant;
import fm.icelink.FileStream;
import fm.icelink.FileStreamAccess;
import fm.icelink.IntegerExtensions;
import fm.icelink.Log;
import fm.icelink.MediaBuffer;
import fm.icelink.MediaFormat;
import fm.icelink.StringExtensions;

public abstract class MediaRecorder<TBuffer extends MediaBuffer<TFormat, TBuffer>, TFormat extends MediaFormat<TFormat>> {
    private TFormat __format = null;
    private String __path;
    private long _basePresentationTimestamp = -1L;
    private FileStream _file;
    private FileAssistant _fileStream;
    private int _flushEvery = 102400;
    private boolean _wasOpened;
    private long _writtenSinceLastFlush = 0L;

    public void close() {
        if (this.getFile() != null) {
            this.doUpdateHeader();
            this.getFile().close();
            this.setFile(null);
        }
    }

    protected abstract void doUpdateHeader();

    protected abstract boolean doWrite(TBuffer var1, long var2);

    protected abstract void doWriteHeader();

    protected FileStream getFile() {
        return this._file;
    }

    protected FileAssistant getFileStream() {
        return this._fileStream;
    }

    public TFormat getFormat() {
        return this.__format;
    }

    public boolean getOpened() {
        return this.getWasOpened();
    }

    public String getPath() {
        return this.__path;
    }

    protected boolean getWasOpened() {
        return this._wasOpened;
    }

    public MediaRecorder(String path) {
        this.__path = path;
    }

    public void open() {
        try {
            this.setFile(new FileStream(this.getPath()));
            int i = 1;
            while (this.getFile().exists()) {
                String str = this.getPath().substring(StringExtensions.lastIndexOf(this.getPath(), "."));
                String str2 = StringExtensions.substring(this.getPath(), 0, StringExtensions.getLength(this.getPath()) - StringExtensions.getLength(str));
                this.setFile(new FileStream(StringExtensions.format("{0}-{1}{2}", str2, IntegerExtensions.toString(i), str)));
                ++i;
            }
            this.getFile().open(FileStreamAccess.Write);
            this.setFileStream(new FileAssistant(this.getFile()));
            this.getFileStream().setLittleEndian(true);
            this.doWriteHeader();
            this.setWasOpened(true);
        }
        catch (Exception exception) {
            Log.error("Recorder cannot open file.", exception);
            this.setWasOpened(false);
        }
    }

    protected void setFile(FileStream value) {
        this._file = value;
    }

    protected void setFileStream(FileAssistant value) {
        this._fileStream = value;
    }

    protected void setWasOpened(boolean value) {
        this._wasOpened = value;
    }

    public boolean write(TBuffer buffer, long presentationTimestamp) {
        if (this.getFile() != null) {
            boolean flag;
            if (this._basePresentationTimestamp == -1L) {
                this._basePresentationTimestamp = presentationTimestamp;
            }
            if (flag = this.doWrite(buffer, presentationTimestamp - this._basePresentationTimestamp)) {
                this._writtenSinceLastFlush += (long)((MediaBuffer)buffer).getDataBuffer().getLength();
                if (this._writtenSinceLastFlush > (long)this._flushEvery) {
                    this.getFile().flush();
                    this._writtenSinceLastFlush = 0L;
                }
            }
            return flag;
        }
        String message = StringExtensions.concat("Cannot write to ", this.__path, ".");
        message = this.getWasOpened() ? StringExtensions.concat(message, " The file was closed.") : StringExtensions.concat(message, " The file must be opened first.");
        Log.error(message);
        return false;
    }
}

