/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.DataBuffer;
import fm.icelink.MacContextBase;
import fm.icelink.MacType;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class MacContext
extends MacContextBase {
    private Mac _mac;

    public MacContext(MacType type, DataBuffer key) {
        super(type);
        try {
            String algorithmName;
            switch (type) {
                case HmacMd5: {
                    algorithmName = "HmacMD5";
                    break;
                }
                case HmacSha1: {
                    algorithmName = "HmacSHA1";
                    break;
                }
                case HmacSha256: {
                    algorithmName = "HmacSHA256";
                    break;
                }
                default: {
                    throw new Exception("Unrecognized MAC type.");
                }
            }
            this._mac = Mac.getInstance(algorithmName);
            this._mac.init(new SecretKeySpec(key.getData(), key.getIndex(), key.getLength(), algorithmName));
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    protected DataBuffer doCompute(DataBuffer input) {
        this._mac.update(input.getData(), input.getIndex(), input.getLength());
        return DataBuffer.wrap(this._mac.doFinal());
    }

    @Override
    protected void doDestroy() {
    }
}

