/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum IcePolicy {
    Required(1),
    Disabled(2),
    Negotiated(3);

    private final int value;
    private static final Map<Integer, IcePolicy> lookup;

    private IcePolicy(int value) {
        this.value = value;
    }

    public int getAssignedValue() {
        return this.value;
    }

    public static IcePolicy getByAssignedValue(int value) {
        return lookup.get(value);
    }

    static {
        lookup = new HashMap<Integer, IcePolicy>();
        for (IcePolicy s : EnumSet.allOf(IcePolicy.class)) {
            lookup.put(s.getAssignedValue(), s);
        }
    }
}

