/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayExtensions;
import fm.icelink.DataBuffer;
import fm.icelink.FeedbackControlFrame;
import fm.icelink.GenericNack;
import fm.icelink.IntegerExtensions;
import fm.icelink.MediaControlFrame;
import fm.icelink.RtpControlFrame;
import fm.icelink.StringExtensions;
import fm.icelink.Utility;

public class GenericNackControlFrame
extends RtpControlFrame {
    private GenericNack[] __genericNacks;

    public GenericNackControlFrame(DataBuffer buffer) {
        super(GenericNackControlFrame.getRegisteredFeedbackMessageType(), buffer);
        if (buffer.getLength() < MediaControlFrame.getFixedHeaderLength() + FeedbackControlFrame.getFixedPayloadHeaderLength()) {
            int num4 = MediaControlFrame.getFixedHeaderLength() + FeedbackControlFrame.getFixedPayloadHeaderLength();
            throw new RuntimeException(new Exception(StringExtensions.concat("DataBuffer must be at least ", IntegerExtensions.toString(num4), " bytes for a GenericNackControlFrame.")));
        }
        DataBuffer feedbackControlInformation = super.getFeedbackControlInformation();
        if (feedbackControlInformation != null) {
            int feedbackControlInformationOffset = super.getFeedbackControlInformationOffset();
            int num2 = feedbackControlInformation.getLength() / GenericNack.getFixedPayloadLength();
            GenericNack[] nackArray = new GenericNack[num2];
            for (int i = 0; i < num2; ++i) {
                nackArray[i] = new GenericNack(super.getDataBuffer().subset(feedbackControlInformationOffset, GenericNack.getFixedPayloadLength()));
                feedbackControlInformationOffset += GenericNack.getFixedPayloadLength();
            }
            this.setGenericNacks(nackArray);
        }
    }

    public GenericNackControlFrame() {
        super(GenericNackControlFrame.getRegisteredFeedbackMessageType());
    }

    public GenericNackControlFrame(GenericNack nack) {
        this(DataBuffer.allocate(MediaControlFrame.getFixedHeaderLength() + FeedbackControlFrame.getFixedPayloadHeaderLength() + GenericNack.getFixedPayloadLength()));
        this.setGenericNack(nack);
        super.setPayloadLengthWithPadding(FeedbackControlFrame.getFixedPayloadHeaderLength() + GenericNack.getFixedPayloadLength());
    }

    public GenericNackControlFrame(GenericNack[] nacks) {
        this(DataBuffer.allocate(MediaControlFrame.getFixedHeaderLength() + FeedbackControlFrame.getFixedPayloadHeaderLength() + ArrayExtensions.getLength(nacks) * GenericNack.getFixedPayloadLength()));
        this.setGenericNacks(nacks);
        super.setPayloadLengthWithPadding(FeedbackControlFrame.getFixedPayloadHeaderLength() + ArrayExtensions.getLength(nacks) * GenericNack.getFixedPayloadLength());
    }

    public GenericNack getGenericNack() {
        return Utility.firstOrDefault(this.getGenericNacks());
    }

    public GenericNack[] getGenericNacks() {
        return this.__genericNacks;
    }

    public static int getRegisteredFeedbackMessageType() {
        return 1;
    }

    private void setGenericNack(GenericNack value) {
        GenericNack[] genericNackArray;
        if (value == null) {
            genericNackArray = null;
        } else {
            GenericNack[] genericNackArray2 = new GenericNack[1];
            genericNackArray = genericNackArray2;
            genericNackArray2[0] = value;
        }
        this.setGenericNacks(genericNackArray);
    }

    private void setGenericNacks(GenericNack[] value) {
        if (value == null) {
            this.__genericNacks = null;
        } else {
            this.__genericNacks = new GenericNack[ArrayExtensions.getLength(value)];
            int offset = MediaControlFrame.getFixedHeaderLength() + FeedbackControlFrame.getFixedPayloadHeaderLength();
            int fixedPayloadLength = GenericNack.getFixedPayloadLength();
            for (int i = 0; i < ArrayExtensions.getLength(value); ++i) {
                DataBuffer buffer = super.getDataBuffer().subset(offset, fixedPayloadLength);
                this.__genericNacks[i] = new GenericNack(buffer);
                buffer.write(value[i].getDataBuffer(), 0);
                offset += fixedPayloadLength;
            }
        }
    }
}

