/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.stun.turn;

import fm.icelink.AddressType;
import fm.icelink.DataBuffer;
import fm.icelink.Global;
import fm.icelink.IntegerExtensions;
import fm.icelink.LocalNetwork;
import fm.icelink.StringExtensions;
import fm.icelink.TransportAddress;
import fm.icelink.stun.Attribute;

public class XorRelayedAddressAttribute
extends Attribute {
    private String _ipAddress;
    private int _port;
    private DataBuffer _transactionId;

    public String getIPAddress() {
        return this._ipAddress;
    }

    public int getPort() {
        return this._port;
    }

    public DataBuffer getTransactionId() {
        return this._transactionId;
    }

    @Override
    public int getTypeValue() {
        return Attribute.getXorRelayedAddressType();
    }

    @Override
    protected int getValueLength() {
        if (Global.equals((Object)LocalNetwork.getAddressType(this.getIPAddress()), (Object)AddressType.IPv4)) {
            return 8;
        }
        return 20;
    }

    public static XorRelayedAddressAttribute readValueFrom(DataBuffer buffer, int offset, DataBuffer transactionId) {
        AddressType addressType = Attribute.readAddressType(buffer, offset + 1);
        if (Global.equals((Object)addressType, (Object)AddressType.getByAssignedValue(0))) {
            return null;
        }
        XorRelayedAddressAttribute attribute = new XorRelayedAddressAttribute();
        attribute.setTransactionId(transactionId);
        attribute.setPort(Attribute.readXorPort(buffer, offset + 2, transactionId));
        attribute.setIPAddress(Attribute.readXorIPAddress(buffer, offset + 4, addressType, transactionId));
        return attribute;
    }

    public void setIPAddress(String value) {
        this._ipAddress = value;
    }

    public void setPort(int value) {
        this._port = value;
    }

    private void setTransactionId(DataBuffer value) {
        this._transactionId = value;
    }

    public String toString() {
        return StringExtensions.format("XOR-RELAYED-ADDRESS {0}:{1}", this.getIPAddress(), IntegerExtensions.toString(this.getPort()));
    }

    @Override
    protected void writeValueTo(DataBuffer buffer, int offset) {
        AddressType addressType = LocalNetwork.getAddressType(this.getIPAddress());
        buffer.write8(0, offset);
        Attribute.writeAddressType(buffer, offset + 1, addressType);
        super.writeXorPort(buffer, offset + 2, this.getPort(), this.getTransactionId());
        super.writeXorIPAddress(buffer, offset + 4, addressType, this.getIPAddress(), this.getTransactionId());
    }

    public XorRelayedAddressAttribute(String ipAddress, int port, DataBuffer transactionId) {
        this.setIPAddress(TransportAddress.sanitizeIPAddress(ipAddress));
        this.setPort(port);
        this.setTransactionId(transactionId);
    }

    private XorRelayedAddressAttribute() {
    }
}

