/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.stun;

import fm.icelink.ArrayExtensions;
import fm.icelink.DataBuffer;
import fm.icelink.IntegerHolder;
import fm.icelink.stun.Attribute;

public class UnknownAttributesAttribute
extends Attribute {
    private int[] _types;

    public int[] getTypes() {
        return this._types;
    }

    @Override
    public int getTypeValue() {
        return Attribute.getUnknownAttributesType();
    }

    @Override
    protected int getValueLength() {
        return ArrayExtensions.getLength(this.getTypes()) * 2;
    }

    public static UnknownAttributesAttribute readValueFrom(DataBuffer buffer, int offset, int length) {
        int[] numArray = new int[length / 2];
        for (int i = 0; i < ArrayExtensions.getLength(numArray); ++i) {
            IntegerHolder _var0 = new IntegerHolder(offset);
            int _var1 = buffer.read16(offset, _var0);
            offset = _var0.getValue();
            numArray[i] = _var1;
        }
        UnknownAttributesAttribute attribute = new UnknownAttributesAttribute();
        attribute.setTypes(numArray);
        return attribute;
    }

    public void setTypes(int[] value) {
        this._types = value;
    }

    @Override
    protected void writeValueTo(DataBuffer buffer, int offset) {
        for (int num : this.getTypes()) {
            IntegerHolder _var0 = new IntegerHolder(offset);
            boolean _var1 = buffer.write16(num, offset, _var0);
            offset = _var0.getValue();
        }
    }
}

