/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayExtensions;
import fm.icelink.ArrayListExtensions;
import fm.icelink.Binary;
import fm.icelink.ByteCollection;
import fm.icelink.ByteExtensions;
import fm.icelink.IntegerHolder;
import fm.icelink.Log;
import fm.icelink.SctpAuthenticatedChunksParameters;
import fm.icelink.SctpChunkListChunkParameter;
import fm.icelink.SctpChunkType;
import fm.icelink.SctpControlChunk;
import fm.icelink.SctpCookiePreservativeChunkParameter;
import fm.icelink.SctpDynamicAddressReconfigurationSupportParameters;
import fm.icelink.SctpForwardTsnSupportedChunkParameter;
import fm.icelink.SctpGenericChunkParameter;
import fm.icelink.SctpHostNameAddressChunkParameter;
import fm.icelink.SctpIPv4ChunkParameter;
import fm.icelink.SctpPartialReliabilitySupportParameters;
import fm.icelink.SctpRandomChunkParameter;
import fm.icelink.SctpRequestedHmacAlgorithmChunkParameter;
import fm.icelink.SctpSupportedAddressTypesChunkParameter;
import fm.icelink.SctpSupportedExtensionsChunkParameter;
import fm.icelink.SctpTlvParameter;
import fm.icelink.StringExtensions;
import java.util.ArrayList;

class SctpInitChunk
extends SctpControlChunk {
    private long _advertisedReceiverWindowCredit;
    private SctpAuthenticatedChunksParameters _authenticatedChunksParameters;
    private SctpDynamicAddressReconfigurationSupportParameters _dynamicAddressReconfigurationParameters;
    private SctpHostNameAddressChunkParameter _hostNameAddress;
    private long _initialTsn;
    private long _initiateTag;
    private SctpIPv4ChunkParameter[] _ipv4Addresses;
    private int _numberOfInboundStreams;
    private int _numberOfOutboundStreams;
    private SctpPartialReliabilitySupportParameters _partialReliabilityParameters;
    private SctpCookiePreservativeChunkParameter _suggestedCookieLifeSpanIncrement;
    private SctpSupportedAddressTypesChunkParameter _supportedAddressTypes;
    private byte[] _supportedExtensionsChunks;
    private SctpGenericChunkParameter[] _unrecognizedParametersThatNeedToBeReportedBackToSender;

    private byte[] generateAdditionalSupportedExtensions() {
        ByteCollection bytes = new ByteCollection();
        if (this.getPartialReliabilityParameters() != null && this.getPartialReliabilityParameters().getPartialReliabilitySupportedByThisEndpoint()) {
            bytes.add(SctpChunkType.getForwardCumulativeTSN());
        }
        if (this.getAuthenticatedChunksParameters() != null && this.getAuthenticatedChunksParameters().getAuthenticatedChunksSupportedByThisEndpoint()) {
            bytes.add(SctpChunkType.getAuth());
        }
        if (this.getDynamicAddressReconfigurationParameters() != null && this.getDynamicAddressReconfigurationParameters().getDynamicAddressReconfigurationSupportedByThisEndpoint()) {
            if (this.getAuthenticatedChunksParameters() != null && !this.getAuthenticatedChunksParameters().getAuthenticatedChunksSupportedByThisEndpoint()) {
                Log.warn("For SCTP dynamic address reconfiguration to work, SCTP authenticated chunks must be supported");
                return new byte[0];
            }
            bytes.add(SctpChunkType.getAsConf());
            bytes.add(SctpChunkType.getAsConfAck());
            bytes.add(SctpChunkType.getReConfig());
        }
        return bytes.toArray();
    }

    public long getAdvertisedReceiverWindowCredit() {
        return this._advertisedReceiverWindowCredit;
    }

    public SctpAuthenticatedChunksParameters getAuthenticatedChunksParameters() {
        return this._authenticatedChunksParameters;
    }

    @Override
    public byte[] getBytes() {
        return SctpInitChunk.getBytes(this);
    }

    public static byte[] getBytes(SctpInitChunk chunk) {
        byte[] extensions;
        ByteCollection bytes = new ByteCollection();
        bytes.add((byte)chunk.getType());
        bytes.add((byte)0);
        bytes.addRange(Binary.toBytes32(chunk.getInitiateTag(), false));
        bytes.addRange(Binary.toBytes32(chunk.getAdvertisedReceiverWindowCredit(), false));
        bytes.addRange(Binary.toBytes16(chunk.getNumberOfOutboundStreams(), false));
        bytes.addRange(Binary.toBytes16(chunk.getNumberOfInboundStreams(), false));
        bytes.addRange(Binary.toBytes32(chunk.getInitialTsn(), false));
        if (chunk.getIPv4Addresses() != null) {
            for (int i = 0; i < ArrayExtensions.getLength(chunk.getIPv4Addresses()); ++i) {
                bytes.addRange(chunk.getIPv4Addresses()[i].getBytes());
            }
        }
        if (chunk.getSuggestedCookieLifeSpanIncrement() != null) {
            bytes.addRange(chunk.getSuggestedCookieLifeSpanIncrement().getBytes());
        }
        if (chunk.getHostNameAddress() != null) {
            bytes.addRange(chunk.getHostNameAddress().getBytes());
        }
        if (chunk.getSupportedAddressTypes() != null) {
            bytes.addRange(chunk.getSupportedAddressTypes().getBytes());
        }
        if (chunk.getPartialReliabilityParameters() != null && chunk.getPartialReliabilityParameters().getPartialReliabilitySupportedByThisEndpoint()) {
            bytes.addRange(new SctpForwardTsnSupportedChunkParameter().getBytes());
        }
        if (ArrayExtensions.getLength(extensions = chunk.generateAdditionalSupportedExtensions()) > 0) {
            bytes.addRange(new SctpSupportedExtensionsChunkParameter(extensions).getBytes());
        }
        if (chunk.getAuthenticatedChunksParameters() != null && chunk.getAuthenticatedChunksParameters().getAuthenticatedChunksSupportedByThisEndpoint() && chunk.getAuthenticatedChunksParameters().getHmacIdentifiers() != null && ArrayExtensions.getLength(chunk.getAuthenticatedChunksParameters().getHmacIdentifiers()) > 0 && chunk.getAuthenticatedChunksParameters().getChunksToBeAuthenticated() != null && ArrayExtensions.getLength(chunk.getAuthenticatedChunksParameters().getChunksToBeAuthenticated()) > 0) {
            bytes.addRange(new SctpRandomChunkParameter(chunk.getAuthenticatedChunksParameters().getRandom()).getBytes());
            bytes.addRange(new SctpRequestedHmacAlgorithmChunkParameter(chunk.getAuthenticatedChunksParameters().getHmacIdentifiers()).getBytes());
            bytes.addRange(new SctpChunkListChunkParameter(chunk.getAuthenticatedChunksParameters().getChunksToBeAuthenticated()).getBytes());
        }
        bytes.insertRange(2, Binary.toBytes16(bytes.getCount() + 2, false));
        return bytes.toArray();
    }

    public SctpDynamicAddressReconfigurationSupportParameters getDynamicAddressReconfigurationParameters() {
        return this._dynamicAddressReconfigurationParameters;
    }

    public SctpHostNameAddressChunkParameter getHostNameAddress() {
        return this._hostNameAddress;
    }

    public long getInitialTsn() {
        return this._initialTsn;
    }

    public long getInitiateTag() {
        return this._initiateTag;
    }

    public SctpIPv4ChunkParameter[] getIPv4Addresses() {
        return this._ipv4Addresses;
    }

    public int getNumberOfInboundStreams() {
        return this._numberOfInboundStreams;
    }

    public int getNumberOfOutboundStreams() {
        return this._numberOfOutboundStreams;
    }

    public SctpPartialReliabilitySupportParameters getPartialReliabilityParameters() {
        return this._partialReliabilityParameters;
    }

    public SctpCookiePreservativeChunkParameter getSuggestedCookieLifeSpanIncrement() {
        return this._suggestedCookieLifeSpanIncrement;
    }

    public SctpSupportedAddressTypesChunkParameter getSupportedAddressTypes() {
        return this._supportedAddressTypes;
    }

    public byte[] getSupportedExtensionsChunks() {
        return this._supportedExtensionsChunks;
    }

    public SctpGenericChunkParameter[] getUnrecognizedParametersThatNeedToBeReportedBackToSender() {
        return this._unrecognizedParametersThatNeedToBeReportedBackToSender;
    }

    public static SctpInitChunk parseBytes(byte[] bytes, IntegerHolder offsetPlus) {
        try {
            int startIndex;
            Log.debug("SCTP manager received INIT chunk from the other party");
            int num = Binary.fromBytes16(bytes, 2, false);
            long initiateTag = Binary.fromBytes32(bytes, 4, false);
            long advertisedReceiverWindowCredit = Binary.fromBytes32(bytes, 8, false);
            int numberOfOutboundStreams = Binary.fromBytes16(bytes, 12, false);
            int numberOfInboundStreams = Binary.fromBytes16(bytes, 14, false);
            long initialTsn = Binary.fromBytes32(bytes, 16, false);
            ArrayList<SctpGenericChunkParameter> list = new ArrayList<SctpGenericChunkParameter>();
            boolean flag = true;
            SctpInitChunk chunk = new SctpInitChunk(initiateTag, advertisedReceiverWindowCredit, numberOfOutboundStreams, numberOfInboundStreams, initialTsn);
            for (startIndex = 20; startIndex < num; startIndex += offsetPlus.getValue()) {
                SctpTlvParameter _var0 = SctpTlvParameter.parseBytes(bytes, startIndex, offsetPlus);
                SctpTlvParameter parameter = _var0;
                if (parameter == null) {
                    offsetPlus.setValue(0);
                    return null;
                }
                if (parameter.getType() != 32773) {
                    if (parameter.getType() == 5 && flag) {
                        Object[] parameterArray;
                        if (chunk.getIPv4Addresses() != null) {
                            parameterArray = new SctpIPv4ChunkParameter[ArrayExtensions.getLength(chunk.getIPv4Addresses()) + 1];
                            for (int i = 0; i < ArrayExtensions.getLength(chunk.getIPv4Addresses()); ++i) {
                                parameterArray[i] = chunk.getIPv4Addresses()[i];
                            }
                        } else {
                            parameterArray = new SctpIPv4ChunkParameter[1];
                        }
                        parameterArray[ArrayExtensions.getLength((Object[])parameterArray) - 1] = (SctpIPv4ChunkParameter)parameter;
                        chunk.setIPv4Addresses((SctpIPv4ChunkParameter[])parameterArray);
                    } else if (parameter.getType() == 9 && flag) {
                        chunk.setSuggestedCookieLifeSpanIncrement((SctpCookiePreservativeChunkParameter)parameter);
                    } else if (parameter.getType() == 11 && flag) {
                        chunk.setHostNameAddress((SctpHostNameAddressChunkParameter)parameter);
                    } else if (parameter.getType() == 12 && flag) {
                        chunk.setSupportedAddressTypes((SctpSupportedAddressTypesChunkParameter)parameter);
                    } else if (parameter.getType() == 49152 && flag) {
                        if (chunk.getPartialReliabilityParameters() == null) {
                            chunk.setPartialReliabilityParameters(new SctpPartialReliabilitySupportParameters(true));
                        } else {
                            chunk.getPartialReliabilityParameters().setPartialReliabilitySupportedByThisEndpoint(true);
                        }
                    } else if (parameter.getType() == 32776 && flag) {
                        chunk.setSupportedExtensionsChunks(((SctpSupportedExtensionsChunkParameter)parameter).getSupportedChunkExtensions());
                        chunk.updateSupportedFunctionalityFromTheListOfSupportedExtensions();
                    } else if (parameter.getType() == 32770 && flag) {
                        if (chunk.getAuthenticatedChunksParameters() == null) {
                            chunk.setAuthenticatedChunksParameters(new SctpAuthenticatedChunksParameters(true, ((SctpRandomChunkParameter)parameter).getRandomNumber(), null, null));
                        } else {
                            chunk.getAuthenticatedChunksParameters().setAuthenticatedChunksSupportedByThisEndpoint(true);
                            chunk.getAuthenticatedChunksParameters().setRandom(((SctpRandomChunkParameter)parameter).getRandomNumber());
                        }
                    } else if (parameter.getType() == 32772 && flag) {
                        if (chunk.getAuthenticatedChunksParameters() == null) {
                            chunk.setAuthenticatedChunksParameters(new SctpAuthenticatedChunksParameters(true, null, ((SctpRequestedHmacAlgorithmChunkParameter)parameter).getHmacIdentifiers(), null));
                        } else {
                            chunk.getAuthenticatedChunksParameters().setAuthenticatedChunksSupportedByThisEndpoint(true);
                            chunk.getAuthenticatedChunksParameters().setHmacIdentifiers(((SctpRequestedHmacAlgorithmChunkParameter)parameter).getHmacIdentifiers());
                        }
                    } else if (parameter.getType() == 32771 && flag) {
                        if (ArrayExtensions.getLength(((SctpChunkListChunkParameter)parameter).getChunkList()) > 0) {
                            if (chunk.getAuthenticatedChunksParameters() == null) {
                                chunk.setAuthenticatedChunksParameters(new SctpAuthenticatedChunksParameters(true, null, null, ((SctpChunkListChunkParameter)parameter).getChunkList()));
                            } else {
                                chunk.getAuthenticatedChunksParameters().setAuthenticatedChunksSupportedByThisEndpoint(true);
                                chunk.getAuthenticatedChunksParameters().setChunksToBeAuthenticated(((SctpChunkListChunkParameter)parameter).getChunkList());
                            }
                        }
                    } else {
                        if (parameter.getDoNotProcessFurtherParametersIfItIsNotRecognized()) {
                            flag = false;
                        }
                        if (parameter.getReportToSenderIfItIsNotRecognized()) {
                            list.add(SctpGenericChunkParameter.toGenericParameter(parameter));
                        }
                    }
                }
                if (!SctpTlvParameter.isInManualListOfUnrecognizedChunkParameterThatMustBeReported(parameter.getType())) continue;
                SctpGenericChunkParameter item = SctpGenericChunkParameter.toGenericParameter(parameter);
                list.add(item);
            }
            if (ArrayListExtensions.getCount(list) > 0) {
                chunk.setUnrecognizedParametersThatNeedToBeReportedBackToSender(list.toArray(new SctpGenericChunkParameter[0]));
            }
            offsetPlus.setValue(startIndex);
            return chunk;
        }
        catch (Exception exception1) {
            Log.error("Failed to process an incoming SCTP INIT chunk");
            offsetPlus.setValue(0);
            return null;
        }
    }

    public SctpInitChunk(long initiateTag, long advertisedReceiverWindowCredit, int numberOfOutboundStreams, int numberOfInboundStreams, long initialTsn) {
        super.setCanBundleWithDataAndSackChunks(false);
        super.setType(SctpChunkType.getInitiation());
        this.setInitiateTag(initiateTag);
        this.setAdvertisedReceiverWindowCredit(advertisedReceiverWindowCredit);
        this.setNumberOfOutboundStreams(numberOfOutboundStreams);
        this.setNumberOfInboundStreams(numberOfInboundStreams);
        this.setInitialTsn(initialTsn);
        super.setUnrecognized(false);
    }

    public SctpInitChunk(long initiateTag, long advertisedReceiverWindowCredit, int numberOfOutboundStreams, int numberOfInboundStreams, long initialTsn, SctpPartialReliabilitySupportParameters partialReliabilityParameters, SctpAuthenticatedChunksParameters authenticatedChunksParameters, SctpDynamicAddressReconfigurationSupportParameters addressReconfigParameters, SctpCookiePreservativeChunkParameter suggestedCookieLifeSpanIncrement, SctpHostNameAddressChunkParameter hostNameAddress) {
        this(initiateTag, advertisedReceiverWindowCredit, numberOfOutboundStreams, numberOfInboundStreams, initialTsn);
        this.setSuggestedCookieLifeSpanIncrement(suggestedCookieLifeSpanIncrement);
        this.setHostNameAddress(hostNameAddress);
        this.setPartialReliabilityParameters(partialReliabilityParameters);
        this.setAuthenticatedChunksParameters(authenticatedChunksParameters);
        this.setDynamicAddressReconfigurationParameters(addressReconfigParameters);
        super.setUnrecognized(false);
    }

    public void setAdvertisedReceiverWindowCredit(long value) {
        this._advertisedReceiverWindowCredit = value;
    }

    public void setAuthenticatedChunksParameters(SctpAuthenticatedChunksParameters value) {
        this._authenticatedChunksParameters = value;
    }

    public void setDynamicAddressReconfigurationParameters(SctpDynamicAddressReconfigurationSupportParameters value) {
        this._dynamicAddressReconfigurationParameters = value;
    }

    public void setHostNameAddress(SctpHostNameAddressChunkParameter value) {
        this._hostNameAddress = value;
    }

    public void setInitialTsn(long value) {
        this._initialTsn = value;
    }

    public void setInitiateTag(long value) {
        this._initiateTag = value;
    }

    public void setIPv4Addresses(SctpIPv4ChunkParameter[] value) {
        this._ipv4Addresses = value;
    }

    public void setNumberOfInboundStreams(int value) {
        this._numberOfInboundStreams = value;
    }

    public void setNumberOfOutboundStreams(int value) {
        this._numberOfOutboundStreams = value;
    }

    public void setPartialReliabilityParameters(SctpPartialReliabilitySupportParameters value) {
        this._partialReliabilityParameters = value;
    }

    public void setSuggestedCookieLifeSpanIncrement(SctpCookiePreservativeChunkParameter value) {
        this._suggestedCookieLifeSpanIncrement = value;
    }

    public void setSupportedAddressTypes(SctpSupportedAddressTypesChunkParameter value) {
        this._supportedAddressTypes = value;
    }

    private void setSupportedExtensionsChunks(byte[] value) {
        this._supportedExtensionsChunks = value;
    }

    public void setUnrecognizedParametersThatNeedToBeReportedBackToSender(SctpGenericChunkParameter[] value) {
        this._unrecognizedParametersThatNeedToBeReportedBackToSender = value;
    }

    private void updateSupportedFunctionalityFromTheListOfSupportedExtensions() {
        boolean flag = false;
        boolean flag2 = false;
        boolean flag3 = false;
        for (int i = 0; i < ArrayExtensions.getLength(this.getSupportedExtensionsChunks()); ++i) {
            if (this.getSupportedExtensionsChunks()[i] == SctpChunkType.getForwardCumulativeTSN()) {
                if (this.getPartialReliabilityParameters() == null) {
                    this.setPartialReliabilityParameters(new SctpPartialReliabilitySupportParameters(true));
                    continue;
                }
                this.getPartialReliabilityParameters().setPartialReliabilitySupportedByThisEndpoint(true);
                continue;
            }
            if (this.getSupportedExtensionsChunks()[i] == SctpChunkType.getReConfig()) {
                if (this.getDynamicAddressReconfigurationParameters() == null) {
                    this.setDynamicAddressReconfigurationParameters(new SctpDynamicAddressReconfigurationSupportParameters(true));
                    continue;
                }
                this.getDynamicAddressReconfigurationParameters().setDynamicAddressReconfigurationSupportedByThisEndpoint(true);
                continue;
            }
            if (this.getSupportedExtensionsChunks()[i] == SctpChunkType.getAsConf()) {
                flag = true;
                continue;
            }
            if (this.getSupportedExtensionsChunks()[i] == SctpChunkType.getAsConfAck()) {
                flag2 = true;
                continue;
            }
            if (this.getSupportedExtensionsChunks()[i] == SctpChunkType.getAuth()) {
                flag3 = true;
                continue;
            }
            Log.debug(StringExtensions.format("Remote party declared ability to send an unknow optional SCTP chunk: {0}", ByteExtensions.toString(this.getSupportedExtensionsChunks()[i])));
        }
        if (flag && flag2 && flag3) {
            if (this.getAuthenticatedChunksParameters() == null) {
                this.setAuthenticatedChunksParameters(new SctpAuthenticatedChunksParameters(true, null, null, null));
            } else {
                this.getAuthenticatedChunksParameters().setAuthenticatedChunksSupportedByThisEndpoint(true);
            }
        }
    }
}

