/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayExtensions;
import fm.icelink.DataBuffer;
import fm.icelink.IntegerExtensions;
import fm.icelink.MediaControlFrame;
import fm.icelink.ReportBlock;
import fm.icelink.StringExtensions;
import fm.icelink.Utility;

public abstract class ReportControlFrame
extends MediaControlFrame {
    private ReportBlock[] __reportBlocks;

    public static int getFixedPayloadHeaderLength() {
        return 4;
    }

    public int getReceptionReportCount() {
        return super.getByte1Last5Bits();
    }

    public ReportBlock getReportBlock() {
        return Utility.firstOrDefault(this.getReportBlocks());
    }

    public ReportBlock getReportBlock(long synchronizationSource) {
        for (ReportBlock block : this.getReportBlocks()) {
            if (block.getSynchronizationSource() != synchronizationSource) continue;
            return block;
        }
        return null;
    }

    public ReportBlock[] getReportBlocks() {
        return this.__reportBlocks != null ? this.__reportBlocks : new ReportBlock[]{};
    }

    public long getSynchronizationSource() {
        return super.getDataBuffer().read32(ReportControlFrame.getFixedPayloadHeaderLength());
    }

    public ReportControlFrame(int payloadType, long synchronizationSource, ReportBlock[] reportBlocks) {
        this(payloadType, synchronizationSource, reportBlocks, MediaControlFrame.getFixedHeaderLength() + ReportControlFrame.getFixedPayloadHeaderLength());
    }

    public ReportControlFrame(int payloadType, long synchronizationSource, ReportBlock reportBlock) {
        ReportBlock[] reportBlockArray;
        if (reportBlock == null) {
            reportBlockArray = null;
        } else {
            ReportBlock[] reportBlockArray2 = new ReportBlock[1];
            reportBlockArray = reportBlockArray2;
            reportBlockArray2[0] = reportBlock;
        }
        this(payloadType, synchronizationSource, reportBlockArray);
    }

    public ReportControlFrame(int payloadType, long synchronizationSource, ReportBlock[] reportBlocks, int reportBlockOffset) {
        super(DataBuffer.allocate(reportBlockOffset + ArrayExtensions.getLength(reportBlocks) * ReportBlock.getFixedPayloadLength()));
        super.setPayloadType(payloadType);
        this.setSynchronizationSource(synchronizationSource);
        this.setReportBlocks(new ReportBlock[ArrayExtensions.getLength(reportBlocks)]);
        this.setReceptionReportCount(ArrayExtensions.getLength(reportBlocks));
        int offset = reportBlockOffset;
        int length = 0;
        for (int i = 0; i < ArrayExtensions.getLength(reportBlocks); ++i) {
            length = reportBlocks[i].getDataBuffer().getLength();
            this.getReportBlocks()[i] = new ReportBlock(super.getDataBuffer().subset(offset, length));
            this.getReportBlocks()[i].getDataBuffer().write(reportBlocks[i].getDataBuffer(), 0);
            offset += length;
        }
        super.setPayloadLengthWithPadding(offset - MediaControlFrame.getFixedHeaderLength());
    }

    public ReportControlFrame(int payloadType, long synchronizationSource, ReportBlock reportBlock, int reportBlockOffset) {
        ReportBlock[] reportBlockArray;
        if (reportBlock == null) {
            reportBlockArray = null;
        } else {
            ReportBlock[] reportBlockArray2 = new ReportBlock[1];
            reportBlockArray = reportBlockArray2;
            reportBlockArray2[0] = reportBlock;
        }
        this(payloadType, synchronizationSource, reportBlockArray, reportBlockOffset);
    }

    public ReportControlFrame(int payloadType, int reportBlockOffset, DataBuffer buffer) {
        super(buffer);
        super.setPayloadType(payloadType);
        if (buffer.getLength() < MediaControlFrame.getFixedHeaderLength() + ReportControlFrame.getFixedPayloadHeaderLength()) {
            int num4 = MediaControlFrame.getFixedHeaderLength() + ReportControlFrame.getFixedPayloadHeaderLength();
            throw new RuntimeException(new Exception(StringExtensions.concat("DataBuffer must be at least ", IntegerExtensions.toString(num4), " bytes")));
        }
        int num = (super.getDataBuffer().getLength() - reportBlockOffset) / ReportBlock.getFixedPayloadLength();
        this.setReceptionReportCount(num);
        this.setReportBlocks(new ReportBlock[num]);
        int offset = reportBlockOffset;
        for (int i = 0; i < num; ++i) {
            this.getReportBlocks()[i] = new ReportBlock(buffer.subset(offset, ReportBlock.getFixedPayloadLength()));
            offset += ReportBlock.getFixedPayloadLength();
        }
    }

    private void setReceptionReportCount(int value) {
        super.setByte1Last5Bits(value);
    }

    public void setReportBlock(ReportBlock value) {
        ReportBlock[] reportBlockArray;
        if (value == null) {
            reportBlockArray = null;
        } else {
            ReportBlock[] reportBlockArray2 = new ReportBlock[1];
            reportBlockArray = reportBlockArray2;
            reportBlockArray2[0] = value;
        }
        this.setReportBlocks(reportBlockArray);
    }

    public void setReportBlocks(ReportBlock[] value) {
        if (value == null) {
            value = new ReportBlock[]{};
        }
        this.setReceptionReportCount(ArrayExtensions.getLength(value));
        this.__reportBlocks = value;
    }

    public void setSynchronizationSource(long value) {
        super.getDataBuffer().write32(value, ReportControlFrame.getFixedPayloadHeaderLength());
    }
}

