/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayExtensions;
import fm.icelink.Error;
import fm.icelink.Global;
import fm.icelink.Guid;
import fm.icelink.HashMapExtensions;
import fm.icelink.Holder;
import fm.icelink.IAction1;
import fm.icelink.IActionDelegate1;
import fm.icelink.IntegerExtensions;
import fm.icelink.Log;
import fm.icelink.ReliableChannel;
import fm.icelink.ReliableChannelState;
import fm.icelink.ReliableSctpProtocol;
import fm.icelink.ReliableTransportState;
import fm.icelink.SctpMessage;
import fm.icelink.SctpTransport;
import fm.icelink.StringExtensions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

class ReliableTransport {
    private HashMap<String, ReliableChannel> __channels;
    private boolean __isDtlsServer;
    private Object __lock;
    private List<IAction1<ReliableTransport>> __onStateChange = new ArrayList<IAction1<ReliableTransport>>();
    private ReliableTransportState __state;
    private Error _error;
    private String _id;
    private SctpTransport _innerTransport;
    private IAction1<ReliableTransport> _onStateChange = new IAction1<ReliableTransport>(){

        @Override
        public void invoke(ReliableTransport p0) {
            for (IAction1 action : new ArrayList(ReliableTransport.this.__onStateChange)) {
                action.invoke(p0);
            }
        }
    };
    private ReliableSctpProtocol _protocol;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChannel(ReliableChannel channel) {
        Object object = this.__lock;
        synchronized (object) {
            int count = HashMapExtensions.getCount(this.__channels);
            channel.removeOnStateChange((IAction1<ReliableChannel>)new IActionDelegate1<ReliableChannel>(){

                @Override
                public String getId() {
                    return "fm.icelink.ReliableTransport.processChannelStateChange";
                }

                @Override
                public void invoke(ReliableChannel channel) {
                    ReliableTransport.this.processChannelStateChange(channel);
                }
            });
            channel.addOnStateChange((IAction1<ReliableChannel>)new IActionDelegate1<ReliableChannel>(){

                @Override
                public String getId() {
                    return "fm.icelink.ReliableTransport.processChannelStateChange";
                }

                @Override
                public void invoke(ReliableChannel channel) {
                    ReliableTransport.this.processChannelStateChange(channel);
                }
            });
            channel.setInnerTransport(this.getInnerTransport());
            channel.setInnerTransportStreamId(count * 2 + 1);
            HashMapExtensions.set(HashMapExtensions.getItem(this.__channels), IntegerExtensions.toString(channel.getInnerTransportStreamId()), channel);
            if (Global.equals((Object)this.__state, (Object)ReliableTransportState.Opening) || Global.equals((Object)this.__state, (Object)ReliableTransportState.Connected)) {
                this.setState(ReliableTransportState.Opening);
                if (this.__isDtlsServer) {
                    this.openChannel(channel);
                }
            }
        }
    }

    public void addOnStateChange(IAction1<ReliableTransport> value) {
        this.__onStateChange.add(value);
    }

    public Error getError() {
        return this._error;
    }

    public String getId() {
        return this._id;
    }

    public SctpTransport getInnerTransport() {
        return this._innerTransport;
    }

    public ReliableSctpProtocol getProtocol() {
        return this._protocol;
    }

    public ReliableTransportState getState() {
        return this.__state;
    }

    private void openChannel(ReliableChannel channel) {
        channel.open();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processChannelStateChange(ReliableChannel channel) {
        ReliableChannelState state = channel.getState();
        Object object = this.__lock;
        synchronized (object) {
            ReliableChannelState _var0 = state;
            if (_var0 == ReliableChannelState.Open) {
                boolean flag = true;
                boolean flag2 = false;
                for (ReliableChannel channel2 : HashMapExtensions.getValues(this.__channels)) {
                    flag &= Global.equals((Object)channel2.getState(), (Object)ReliableChannelState.Open);
                    if (!Global.equals((Object)channel2.getState(), (Object)ReliableChannelState.Failed)) continue;
                    this.setError(channel2.getError());
                    flag2 = true;
                }
                if (flag2) {
                    this.setState(ReliableTransportState.Failed);
                } else if (flag) {
                    this.setState(ReliableTransportState.Connected);
                }
            } else if (_var0 == ReliableChannelState.Failed) {
                this.setError(channel.getError());
                this.setState(ReliableTransportState.Failed);
            }
        }
    }

    private void processIncomingSctpMessage(SctpMessage msg) {
        try {
            String key = IntegerExtensions.toString(msg.getStreamId());
            if (!this.__channels.containsKey(key)) {
                Log.debug(StringExtensions.format("Reliable Data: attempt to communicate on an unassigned channel {0}.", key));
            } else {
                ReliableChannel channel = null;
                Holder<Object> _var0 = new Holder<Object>(channel);
                boolean _var1 = HashMapExtensions.tryGetValue(this.__channels, key, _var0);
                channel = _var0.getValue();
                if (!_var1) {
                    throw new RuntimeException(new Exception(StringExtensions.format("Reliable Data: Channel ID {0} could not be retrieved.", key)));
                }
                channel.receiveSctpMessage(msg);
            }
        }
        catch (Exception exception) {
            Log.error("Reliable Data: Could not process incoming Sctp Message.", exception);
        }
    }

    private void raiseStateChange() {
        IAction1<ReliableTransport> onStateChange = this._onStateChange;
        if (onStateChange != null) {
            onStateChange.invoke(this);
        }
    }

    public ReliableTransport(Object lockObject, SctpTransport innerTransport, ReliableChannel[] channels) {
        this.__lock = lockObject;
        this.setId(Guid.newGuid().toString().replace("-", ""));
        this.setState(ReliableTransportState.New);
        this.__channels = new HashMap();
        this.setProtocol(ReliableSctpProtocol.RtcDataChannelSctpProtocol);
        this.setInnerTransport(innerTransport);
        for (int i = 0; i < ArrayExtensions.getLength(channels); ++i) {
            ReliableChannel channel = channels[i];
            channel.removeOnStateChange((IAction1<ReliableChannel>)new IActionDelegate1<ReliableChannel>(){

                @Override
                public String getId() {
                    return "fm.icelink.ReliableTransport.processChannelStateChange";
                }

                @Override
                public void invoke(ReliableChannel channel) {
                    ReliableTransport.this.processChannelStateChange(channel);
                }
            });
            channel.addOnStateChange((IAction1<ReliableChannel>)new IActionDelegate1<ReliableChannel>(){

                @Override
                public String getId() {
                    return "fm.icelink.ReliableTransport.processChannelStateChange";
                }

                @Override
                public void invoke(ReliableChannel channel) {
                    ReliableTransport.this.processChannelStateChange(channel);
                }
            });
            channel.setInnerTransport(this.getInnerTransport());
            channel.setInnerTransportStreamId(2 * i + 1);
            HashMapExtensions.set(HashMapExtensions.getItem(this.__channels), IntegerExtensions.toString(channel.getInnerTransportStreamId()), channel);
        }
        this.getInnerTransport().setOnMessage((IAction1<SctpMessage>)new IActionDelegate1<SctpMessage>(){

            @Override
            public String getId() {
                return "fm.icelink.ReliableTransport.processIncomingSctpMessage";
            }

            @Override
            public void invoke(SctpMessage msg) {
                ReliableTransport.this.processIncomingSctpMessage(msg);
            }
        });
    }

    public void removeOnStateChange(IAction1<ReliableTransport> value) {
        IAction1 match;
        if (value instanceof IActionDelegate1 && (match = Global.findIActionDelegate1WithId(this.__onStateChange, ((IActionDelegate1)value).getId())) != null) {
            value = match;
        }
        this.__onStateChange.remove(value);
    }

    private void setError(Error value) {
        this._error = value;
    }

    private void setId(String value) {
        this._id = value;
    }

    public void setInnerTransport(SctpTransport value) {
        this._innerTransport = value;
    }

    private void setProtocol(ReliableSctpProtocol value) {
        this._protocol = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setState(ReliableTransportState value) {
        Object object = this.__lock;
        synchronized (object) {
            if (!Global.equals((Object)this.__state, (Object)value)) {
                this.__state = value;
                this.raiseStateChange();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean start(boolean isDtlsServer) {
        Object object = this.__lock;
        synchronized (object) {
            this.__isDtlsServer = isDtlsServer;
            if (!Global.equals((Object)this.getState(), (Object)ReliableTransportState.New)) {
                return false;
            }
            this.setState(ReliableTransportState.Opening);
            if (this.__isDtlsServer) {
                for (ReliableChannel channel : HashMapExtensions.getValues(this.__channels)) {
                    this.openChannel(channel);
                }
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.__lock;
        synchronized (object) {
            this.setState(ReliableTransportState.Closing);
            this.getInnerTransport().setOnMessage(null);
            for (ReliableChannel channel : HashMapExtensions.getValues(this.__channels)) {
                channel.removeOnStateChange((IAction1<ReliableChannel>)new IActionDelegate1<ReliableChannel>(){

                    @Override
                    public String getId() {
                        return "fm.icelink.ReliableTransport.processChannelStateChange";
                    }

                    @Override
                    public void invoke(ReliableChannel channel) {
                        ReliableTransport.this.processChannelStateChange(channel);
                    }
                });
                channel.close();
            }
            this.setState(ReliableTransportState.Closed);
        }
    }
}

