/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.DataBuffer;
import fm.icelink.IntegerExtensions;
import fm.icelink.RtcpPacket;
import fm.icelink.StringExtensions;

public class MediaControlFrame {
    private DataBuffer __dataBuffer = null;
    private RtcpPacket _packet;

    public int getByte1Last5Bits() {
        return this.getPacket().getByte1Last5Bits();
    }

    public DataBuffer getDataBuffer() {
        return this.__dataBuffer;
    }

    public static int getFixedHeaderLength() {
        return 4;
    }

    RtcpPacket getPacket() {
        return this._packet;
    }

    public DataBuffer getPayload() {
        return this.getPacket().getPayload();
    }

    public int getPayloadLengthWithPadding() {
        return this.getPacket().getPayloadLengthWithPadding();
    }

    public int getPayloadType() {
        return this.getPacket().getPayloadType();
    }

    public int getVersion() {
        return this.getPacket().getVersion();
    }

    public MediaControlFrame() {
        this(DataBuffer.allocate(MediaControlFrame.getFixedHeaderLength()));
    }

    public MediaControlFrame(DataBuffer buffer) {
        if (buffer.getLength() < MediaControlFrame.getFixedHeaderLength()) {
            throw new RuntimeException(new Exception(StringExtensions.concat("DataBuffer must be at least ", IntegerExtensions.toString(MediaControlFrame.getFixedHeaderLength()), " bytes long.")));
        }
        this.setDataBuffer(buffer);
    }

    public void setByte1Last5Bits(int value) {
        this.getPacket().setByte1Last5Bits(value);
    }

    protected void setDataBuffer(DataBuffer value) {
        this.__dataBuffer = value;
        this.setPacket(new RtcpPacket(this.__dataBuffer));
    }

    void setPacket(RtcpPacket value) {
        this._packet = value;
    }

    private void setPayload(DataBuffer value) {
        this.getPacket().setPayload(value);
    }

    protected void setPayloadLengthWithPadding(int value) {
        this.getPacket().setPayloadLengthWithPadding(value);
    }

    public void setPayloadType(int value) {
        this.getPacket().setPayloadType(value);
    }

    public void setVersion(int value) {
        this.getPacket().setVersion(value);
    }
}

