/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.stun;

import fm.icelink.DataBuffer;
import fm.icelink.StringExtensions;
import fm.icelink.Utf8;
import fm.icelink.stun.Attribute;

public class UsernameAttribute
extends Attribute {
    private String __value;

    @Override
    public int getTypeValue() {
        return Attribute.getUsernameType();
    }

    public String getValue() {
        return this.__value;
    }

    @Override
    protected int getValueLength() {
        return Utf8.getByteCount(this.getValue());
    }

    public static UsernameAttribute readValueFrom(DataBuffer buffer, int offset, int length) {
        String str = Utf8.decode(buffer.getData(), buffer.getIndex() + offset, length).trim();
        while (str.endsWith("\u0000")) {
            str = StringExtensions.substring(str, 0, StringExtensions.getLength(str) - 1);
        }
        UsernameAttribute attribute = new UsernameAttribute();
        attribute.setValue(str);
        return attribute;
    }

    public void setValue(String value) {
        if (Utf8.getByteCount(value) > 512) {
            throw new RuntimeException(new Exception("value may not exceed 512 bytes in UTF-8 encoding."));
        }
        this.__value = value;
    }

    public String toString() {
        return StringExtensions.format("USERNAME {0}", this.getValue());
    }

    public UsernameAttribute(String value) {
        this.setValue(value);
    }

    private UsernameAttribute() {
    }

    @Override
    protected void writeValueTo(DataBuffer buffer, int offset) {
        buffer.writeBytes(Utf8.encode(this.getValue()), offset);
    }
}

