/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.stun;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum MessageType {
    Request(1),
    Indication(2),
    SuccessResponse(3),
    ErrorResponse(4);

    private final int value;
    private static final Map<Integer, MessageType> lookup;

    private MessageType(int value) {
        this.value = value;
    }

    public int getAssignedValue() {
        return this.value;
    }

    public static MessageType getByAssignedValue(int value) {
        return lookup.get(value);
    }

    static {
        lookup = new HashMap<Integer, MessageType>();
        for (MessageType s : EnumSet.allOf(MessageType.class)) {
            lookup.put(s.getAssignedValue(), s);
        }
    }
}

