/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.sdp;

import fm.icelink.ArrayExtensions;
import fm.icelink.Global;
import fm.icelink.StringExtensions;
import fm.icelink.sdp.Attribute;
import fm.icelink.sdp.AttributeType;
import fm.icelink.sdp.MediaStreamIdSemanticToken;

public class MediaStreamIdSemanticAttribute
extends Attribute {
    private String _msIdList;
    private MediaStreamIdSemanticToken _semanticToken;

    public static MediaStreamIdSemanticAttribute fromAttributeValue(String value) {
        Object[] strArray = StringExtensions.split(value, new char[]{' '});
        if (ArrayExtensions.getLength(strArray) == 0) {
            return new MediaStreamIdSemanticAttribute(MediaStreamIdSemanticToken.Wms);
        }
        Object semanticToken = strArray[0];
        MediaStreamIdSemanticToken semanticTokenFromString = MediaStreamIdSemanticAttribute.getSemanticTokenFromString((String)semanticToken);
        if (ArrayExtensions.getLength(strArray) == 1) {
            return new MediaStreamIdSemanticAttribute(semanticTokenFromString);
        }
        return new MediaStreamIdSemanticAttribute(semanticTokenFromString, value.substring(StringExtensions.getLength((String)semanticToken) + 1));
    }

    @Override
    protected String getAttributeValue() {
        if (StringExtensions.isNullOrEmpty(this.getMsIdList())) {
            return MediaStreamIdSemanticAttribute.getSemanticTokenString(this.getSemanticToken());
        }
        return StringExtensions.concat(MediaStreamIdSemanticAttribute.getSemanticTokenString(this.getSemanticToken()), " ", this.getMsIdList());
    }

    public String getMsIdList() {
        return this._msIdList;
    }

    private MediaStreamIdSemanticToken getSemanticToken() {
        return this._semanticToken;
    }

    private static MediaStreamIdSemanticToken getSemanticTokenFromString(String semanticToken) {
        String str = semanticToken;
        if (str != null && Global.equals(str, "WMS")) {
            return MediaStreamIdSemanticToken.Wms;
        }
        return MediaStreamIdSemanticToken.Wms;
    }

    private static String getSemanticTokenString(MediaStreamIdSemanticToken semanticToken) {
        if (Global.equals((Object)semanticToken, (Object)MediaStreamIdSemanticToken.Wms)) {
            return "WMS";
        }
        return "WMS";
    }

    public MediaStreamIdSemanticAttribute(MediaStreamIdSemanticToken semanticToken, String msidList) {
        super.setAttributeType(AttributeType.MediaStreamIdSemanticAttribute);
        this.setSemanticToken(semanticToken);
        this.setMsIdList(msidList);
    }

    public MediaStreamIdSemanticAttribute(MediaStreamIdSemanticToken semanticToken) {
        this(semanticToken, "*");
    }

    public void setMsIdList(String value) {
        this._msIdList = value;
    }

    private void setSemanticToken(MediaStreamIdSemanticToken value) {
        this._semanticToken = value;
    }
}

