/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.BitAssistant;
import fm.icelink.HashMapExtensions;
import fm.icelink.Holder;
import fm.icelink.MediaFormat;
import java.util.HashMap;

public class VideoFormat
extends MediaFormat<VideoFormat> {
    private static HashMap<String, Integer> _fourCCLookup = new HashMap();
    private static HashMap<Integer, String> _reverseFourCCLookup = null;

    @Override
    public VideoFormat clone() {
        return (VideoFormat)super.clone();
    }

    @Override
    protected VideoFormat createInstance() {
        return new VideoFormat();
    }

    public static int formatNameToFourCC(String formatName) {
        if (_fourCCLookup.containsKey(formatName)) {
            return HashMapExtensions.getItem(_fourCCLookup).get(formatName);
        }
        return 0;
    }

    public String fourCCToFormatName(int fourcc) {
        if (_reverseFourCCLookup == null) {
            HashMap dictionary = new HashMap();
            for (String str : HashMapExtensions.getKeys(_fourCCLookup)) {
                HashMapExtensions.set(HashMapExtensions.getItem(dictionary), HashMapExtensions.getItem(_fourCCLookup).get(str), str);
            }
            _reverseFourCCLookup = dictionary;
        }
        String str2 = null;
        Holder<Object> _var0 = new Holder<Object>(str2);
        boolean _var1 = HashMapExtensions.tryGetValue(_reverseFourCCLookup, Integer.valueOf(fourcc), _var0);
        str2 = _var0.getValue();
        if (_var1) {
            return str2;
        }
        return "";
    }

    public static VideoFormat getAbgr() {
        return new VideoFormat(VideoFormat.getAbgrName());
    }

    public static String getAbgrName() {
        return "ABGR";
    }

    public static VideoFormat getArgb() {
        return new VideoFormat(VideoFormat.getArgbName());
    }

    public static String getArgbName() {
        return "ARGB";
    }

    public static VideoFormat getBgr() {
        return new VideoFormat(VideoFormat.getBgrName());
    }

    public static VideoFormat getBgra() {
        return new VideoFormat(VideoFormat.getBgraName());
    }

    public static String getBgraName() {
        return "BGRA";
    }

    public static String getBgrName() {
        return "BGR";
    }

    public int getFourCC() {
        return VideoFormat.formatNameToFourCC(super.getName());
    }

    public static VideoFormat getH264() {
        return new VideoFormat(VideoFormat.getH264Name());
    }

    public static String getH264Name() {
        return "H264";
    }

    public static VideoFormat getI420() {
        return new VideoFormat(VideoFormat.getI420Name());
    }

    public static String getI420Name() {
        return "I420";
    }

    public static VideoFormat getNv12() {
        return new VideoFormat(VideoFormat.getNv12Name());
    }

    public static String getNv12Name() {
        return "NV12";
    }

    public static VideoFormat getNv21() {
        return new VideoFormat(VideoFormat.getNv21Name());
    }

    public static String getNv21Name() {
        return "NV21";
    }

    @Override
    public String getParameters() {
        return null;
    }

    public static VideoFormat getRgb() {
        return new VideoFormat(VideoFormat.getRgbName());
    }

    public static VideoFormat getRgba() {
        return new VideoFormat(VideoFormat.getRgbaName());
    }

    public static String getRgbaName() {
        return "RGBA";
    }

    public static String getRgbName() {
        return "RGB";
    }

    public static String getVp8Name() {
        return "VP8";
    }

    public static String getVp9Name() {
        return "VP9";
    }

    public static VideoFormat getYv12() {
        return new VideoFormat(VideoFormat.getYv12Name());
    }

    public static String getYv12Name() {
        return "YV12";
    }

    public void setFourCC(int value) {
        super.setName(this.fourCCToFormatName(value));
    }

    public static int toFourCC(char a, char b, char c, char d) {
        return a | BitAssistant.leftShiftInteger(b, 8) | BitAssistant.leftShiftInteger(c, 16) | BitAssistant.leftShiftInteger(d, 24);
    }

    public static int toFourCC(String fourcc) {
        return VideoFormat.toFourCC(fourcc.charAt(0), fourcc.charAt(1), fourcc.charAt(2), fourcc.charAt(3));
    }

    public VideoFormat(String name, int clockRate) {
        super(name, clockRate);
    }

    public VideoFormat(String name) {
        this(name, 90000);
    }

    protected VideoFormat() {
    }

    static {
        HashMapExtensions.set(HashMapExtensions.getItem(_fourCCLookup), VideoFormat.getRgbName(), VideoFormat.toFourCC('r', 'a', 'w', ' '));
        HashMapExtensions.set(HashMapExtensions.getItem(_fourCCLookup), VideoFormat.getBgrName(), VideoFormat.toFourCC('2', '4', 'B', 'G'));
        HashMapExtensions.set(HashMapExtensions.getItem(_fourCCLookup), VideoFormat.getNv12Name(), VideoFormat.toFourCC('N', 'V', '1', '2'));
        HashMapExtensions.set(HashMapExtensions.getItem(_fourCCLookup), VideoFormat.getNv21Name(), VideoFormat.toFourCC('N', 'V', '2', '1'));
        HashMapExtensions.set(HashMapExtensions.getItem(_fourCCLookup), VideoFormat.getI420Name(), VideoFormat.toFourCC('I', '4', '2', '0'));
        HashMapExtensions.set(HashMapExtensions.getItem(_fourCCLookup), VideoFormat.getYv12Name(), VideoFormat.toFourCC('Y', 'V', '1', '2'));
        HashMapExtensions.set(HashMapExtensions.getItem(_fourCCLookup), VideoFormat.getArgbName(), VideoFormat.toFourCC('A', 'R', 'G', 'B'));
        HashMapExtensions.set(HashMapExtensions.getItem(_fourCCLookup), VideoFormat.getAbgrName(), VideoFormat.toFourCC('A', 'B', 'G', 'R'));
        HashMapExtensions.set(HashMapExtensions.getItem(_fourCCLookup), VideoFormat.getRgbaName(), VideoFormat.toFourCC('R', 'G', 'B', 'A'));
        HashMapExtensions.set(HashMapExtensions.getItem(_fourCCLookup), VideoFormat.getBgraName(), VideoFormat.toFourCC('B', 'G', 'R', 'A'));
    }
}

