/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.DataBuffer;

public class SoundUtility {
    public static float floatFromShort(short value) {
        float num = (float)value / 32768.0f;
        if (num > 1.0f) {
            num = 1.0f;
        }
        if (num < -1.0f) {
            num = -1.0f;
        }
        return num;
    }

    public static DataBuffer monoToStereo(DataBuffer mono, DataBuffer stereo) {
        int length = mono.getLength();
        if (length % 2 == 0) {
            int offset = 0;
            for (int i = 0; i < length; i += 2) {
                int num4 = mono.read16Signed(i);
                stereo.write16(num4, offset);
                stereo.write16(num4, offset += 2);
                offset += 2;
            }
            return stereo;
        }
        return null;
    }

    public static short shortFromFloat(float value) {
        if ((value *= 32768.0f) > 32767.0f) {
            value = 32767.0f;
        }
        if (value < -32768.0f) {
            value = -32768.0f;
        }
        return (short)value;
    }

    public static DataBuffer stereoToMono(DataBuffer stereo, DataBuffer mono) {
        int length = stereo.getLength();
        if (length % 4 == 0) {
            int offset = 0;
            for (int i = 0; i < length; i += 4) {
                int num4 = stereo.read16Signed(i);
                int num5 = stereo.read16Signed(i + 2);
                int num6 = (num4 + num5) / 2;
                mono.write16(num6, offset);
                offset += 2;
            }
            return mono;
        }
        return null;
    }

    static void test() {
    }
}

