/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.AudioBuffer;
import fm.icelink.AudioFormat;
import fm.icelink.AudioFrame;
import fm.icelink.Constants;
import fm.icelink.DataBuffer;
import fm.icelink.IAction1;
import fm.icelink.SoundTimestampContext;

class SoundReframerContext
extends SoundTimestampContext {
    private long __baseTimestamp = 0L;
    private int __currentFrameDataLength = 0;
    private DataBuffer __frameAccumulator = null;
    private IAction1<AudioFrame> _onFrame;

    private void cloneAndRaise(AudioFrame frame, AudioFormat format, double duration, DataBuffer chunkDataBuffer) {
        chunkDataBuffer.setLittleEndian(format.getLittleEndian());
        AudioFrame frame2 = frame.clone();
        frame2.setDuration(duration);
        frame2.setTimestamp(super.getNextTimestamp(format.getClockRate(), duration));
        frame2.removeBuffers();
        frame2.addBuffer(new AudioBuffer(chunkDataBuffer, format));
        this.raise(frame2);
    }

    public IAction1<AudioFrame> getOnFrame() {
        return this._onFrame;
    }

    public void processFrame(AudioFrame frame, AudioBuffer buffer) {
        double frameDuration = super.getFrameDuration();
        if (frame.getDuration() == frameDuration && (this.__frameAccumulator == null || this.__frameAccumulator.getLength() == 0)) {
            this.raise(frame);
        } else {
            AudioFormat format = (AudioFormat)buffer.getFormat();
            int count = (int)((double)(format.getClockRate() * format.getChannelCount() * 2) * frameDuration / (double)Constants.getMillisecondsPerSecond());
            if (this.__frameAccumulator == null) {
                this.__frameAccumulator = DataBuffer.allocate(count, format.getLittleEndian());
                this.__frameAccumulator.resize(0);
                this.__currentFrameDataLength = count;
                this.__baseTimestamp = frame.getTimestamp();
            }
            if (count > this.__currentFrameDataLength) {
                int length = this.__frameAccumulator.getLength();
                this.__frameAccumulator.resize(count);
                this.__frameAccumulator.resize(length);
                this.__currentFrameDataLength = count;
            }
            if (count < this.__currentFrameDataLength) {
                int offset = 0;
                int num5 = this.__frameAccumulator.getLength() % count;
                for (int i = 0; i < num5; ++i) {
                    this.cloneAndRaise(frame, format, frameDuration, this.__frameAccumulator.subset(offset, count));
                    offset += count;
                }
                if (offset > 0) {
                    int num7 = this.__frameAccumulator.getLength() - offset;
                    this.__frameAccumulator.write(this.__frameAccumulator.subset(offset, num7), 0);
                    this.__frameAccumulator.resize(num7);
                    this.__currentFrameDataLength = count;
                }
            }
            DataBuffer dataBuffer = buffer.getDataBuffer();
            if (this.__frameAccumulator.getLength() + dataBuffer.getLength() <= count) {
                this.__frameAccumulator.append(dataBuffer);
                if (this.__frameAccumulator.getLength() == count) {
                    this.cloneAndRaise(frame, format, frameDuration, this.__frameAccumulator);
                    this.__frameAccumulator.resize(0);
                }
            } else {
                DataBuffer buffer3;
                if (this.__frameAccumulator.getLength() > 0) {
                    int num8 = count - this.__frameAccumulator.getLength();
                    this.__frameAccumulator.append(dataBuffer.subset(0, num8));
                    this.cloneAndRaise(frame, format, frameDuration, this.__frameAccumulator);
                    this.__frameAccumulator.resize(0);
                    buffer3 = dataBuffer.subset(num8);
                } else {
                    buffer3 = dataBuffer;
                }
                while (buffer3.getLength() >= count) {
                    this.cloneAndRaise(frame, format, frameDuration, buffer3.subset(0, count));
                    buffer3 = buffer3.subset(count);
                }
                if (buffer3.getLength() > 0) {
                    this.__frameAccumulator.append(buffer3);
                }
            }
        }
    }

    private void raise(AudioFrame frame) {
        IAction1<AudioFrame> onFrame = this.getOnFrame();
        if (onFrame != null) {
            onFrame.invoke(frame);
        }
    }

    public void setOnFrame(IAction1<AudioFrame> value) {
        this._onFrame = value;
    }

    public SoundReframerContext(double frameDuration) {
        super(frameDuration);
    }
}

