/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayExtensions;
import fm.icelink.ArrayListExtensions;
import fm.icelink.Future;
import fm.icelink.Guid;
import fm.icelink.IElement;
import fm.icelink.IFunction1;
import fm.icelink.IMediaElement;
import fm.icelink.IMediaInput;
import fm.icelink.IMediaInputCollection;
import fm.icelink.IMediaOutput;
import fm.icelink.IMediaOutputCollection;
import fm.icelink.IMediaTrack;
import fm.icelink.MediaBranch;
import fm.icelink.MediaBuffer;
import fm.icelink.MediaBufferCollection;
import fm.icelink.MediaFormat;
import fm.icelink.MediaFrame;
import fm.icelink.MediaPipe;
import fm.icelink.MediaSink;
import fm.icelink.MediaSource;
import fm.icelink.MediaTrackBase;
import fm.icelink.Promise;
import fm.icelink.SinkOutput;
import fm.icelink.SourceInput;
import fm.icelink.Utility;
import java.util.ArrayList;

public abstract class MediaTrack<TIOutput extends IMediaOutput<TIOutput, TIInput, TFrame, TBuffer, TBufferCollection, TFormat>, TIOutputCollection extends IMediaOutputCollection<TIOutput, TIInput, TFrame, TBuffer, TBufferCollection, TFormat, TIOutputCollection>, TIInput extends IMediaInput<TIOutput, TIInput, TFrame, TBuffer, TBufferCollection, TFormat>, TIInputCollection extends IMediaInputCollection<TIOutput, TIInput, TFrame, TBuffer, TBufferCollection, TFormat, TIInputCollection>, TIElement extends IMediaElement, TSource extends MediaSource<TIOutput, TIInput, TIInputCollection, TSource, TFrame, TBuffer, TBufferCollection, TFormat>, TSink extends MediaSink<TIOutput, TIOutputCollection, TIInput, TSink, TFrame, TBuffer, TBufferCollection, TFormat>, TPipe extends MediaPipe<TIOutput, TIOutputCollection, TIInput, TIInputCollection, TPipe, TFrame, TBuffer, TBufferCollection, TFormat>, TTrack extends MediaTrack<TIOutput, TIOutputCollection, TIInput, TIInputCollection, TIElement, TSource, TSink, TPipe, TTrack, TBranch, TFrame, TBuffer, TBufferCollection, TFormat>, TBranch extends MediaBranch<TIOutput, TIOutputCollection, TIInput, TIInputCollection, TIElement, TSource, TSink, TPipe, TTrack, TBranch, TFrame, TBuffer, TBufferCollection, TFormat>, TFrame extends MediaFrame<TBuffer, TBufferCollection, TFormat, TFrame>, TBuffer extends MediaBuffer<TFormat, TBuffer>, TBufferCollection extends MediaBufferCollection<TBuffer, TBufferCollection, TFormat>, TFormat extends MediaFormat<TFormat>>
extends MediaTrackBase
implements IMediaTrack,
IMediaElement,
IElement {
    private String _id;

    protected abstract void addElement(TIElement var1);

    private void addToBranch(TBranch branch, TIInput next) {
        for (MediaTrack local : branch.getTracks()) {
            if (local == null || local.getIsTerminated() || local.getIsEmpty()) continue;
            if (local.getIsBranched()) {
                this.addToBranch((MediaBranch)local.getLastElement(), next);
                continue;
            }
            ((IMediaOutput)local.getLastElement()).addOutput(next);
        }
    }

    protected abstract TIInput[] arrayFromInputs(ArrayList<TIInput> var1);

    protected abstract TIOutput[] arrayFromOutputs(ArrayList<TIOutput> var1);

    protected abstract TBranch branchFromTracks(TTrack[] var1);

    @Override
    public Future<Object> changeSinkOutput(SinkOutput sinkOutput) {
        TSink sink = this.getSink();
        if (sink != null) {
            return ((MediaSink)sink).changeOutput(sinkOutput);
        }
        return null;
    }

    @Override
    public Future<Object> changeSourceInput(SourceInput sourceInput) {
        TSource source = this.getSource();
        if (source != null) {
            return ((MediaSource)source).changeInput(sourceInput);
        }
        return null;
    }

    @Override
    public boolean destroy() {
        boolean flag = false;
        for (IMediaElement local : this.getElements()) {
            if (!local.destroy()) continue;
            flag = true;
        }
        return flag;
    }

    public TIElement findElement(IFunction1<TIElement, Boolean> where) {
        return this.findElement(where, true);
    }

    public TIElement findElement(IFunction1<TIElement, Boolean> where, boolean recurse) {
        ArrayList<TIElement> list = this.findElements(where, recurse);
        if (ArrayListExtensions.getCount(list) == 0) {
            return null;
        }
        return (TIElement)((IMediaElement)ArrayListExtensions.getItem(list).get(0));
    }

    public ArrayList<TIElement> findElements(IFunction1<TIElement, Boolean> where) {
        return this.findElements(where, true);
    }

    public ArrayList<TIElement> findElements(IFunction1<TIElement, Boolean> where, boolean recurse) {
        ArrayList<IMediaElement> list = new ArrayList<IMediaElement>();
        for (IMediaElement local : this.getElements()) {
            if (where.invoke(local).booleanValue()) {
                list.add(local);
            }
            if (!recurse || !this.isBranch(local)) continue;
            MediaBranch local3 = (MediaBranch)local;
            for (MediaTrack local2 : local3.getTracks()) {
                ArrayListExtensions.addRange(list, local2.findElements(where, recurse));
            }
        }
        return list;
    }

    @Override
    public boolean getDisabled() {
        TIElement firstElement = this.getFirstElement();
        return firstElement != null && firstElement.getDisabled();
    }

    public abstract TIElement[] getElements();

    public TIElement getFirstElement() {
        return (TIElement)Utility.firstOrDefault(this.getElements());
    }

    @Override
    public String getId() {
        return this._id;
    }

    public TIInput getInput() {
        Object[] inputs = this.getInputs();
        if (ArrayExtensions.getLength(inputs) == 0) {
            return null;
        }
        return (TIInput)inputs[0];
    }

    public TFormat getInputFormat() {
        TIElement firstElement = this.getFirstElement();
        if (firstElement != null && this.isInput(firstElement)) {
            IMediaInput local3 = (IMediaInput)firstElement;
            return local3.getInputFormat();
        }
        return null;
    }

    public TIInput[] getInputs() {
        ArrayList<IMediaInput> inputs = new ArrayList<IMediaInput>();
        TIElement firstElement = this.getFirstElement();
        if (this.isInput(firstElement)) {
            inputs.add((IMediaInput)firstElement);
        } else if (this.isBranch(firstElement)) {
            MediaBranch local2 = (MediaBranch)firstElement;
            for (MediaTrack local3 : local2.getTracks()) {
                if (local3 == null) continue;
                ArrayListExtensions.addRange(inputs, local3.getInputs());
            }
        }
        return this.arrayFromInputs(inputs);
    }

    public boolean getIsBranched() {
        return !this.getIsEmpty() && this.isBranch(this.getLastElement());
    }

    public boolean getIsEmpty() {
        return this.getFirstElement() == null;
    }

    public boolean getIsTerminated() {
        return !this.getIsEmpty() && this.isSink(this.getLastElement());
    }

    @Override
    public abstract String getLabel();

    public TIElement getLastElement() {
        return (TIElement)Utility.lastOrDefault(this.getElements());
    }

    @Override
    public boolean getMuted() {
        for (IMediaElement local : this.getElements()) {
            if (!local.getMuted()) continue;
            return true;
        }
        return false;
    }

    public TIOutput getOutput() {
        Object[] outputs = this.getOutputs();
        if (ArrayExtensions.getLength(outputs) == 0) {
            return null;
        }
        return (TIOutput)outputs[0];
    }

    public TFormat getOutputFormat() {
        TIElement lastElement = this.getLastElement();
        if (lastElement != null && this.isOutput(lastElement)) {
            IMediaOutput local3 = (IMediaOutput)lastElement;
            return local3.getOutputFormat();
        }
        return null;
    }

    public TIOutput[] getOutputs() {
        ArrayList<IMediaOutput> outputs = new ArrayList<IMediaOutput>();
        TIElement lastElement = this.getLastElement();
        if (this.isOutput(lastElement)) {
            outputs.add((IMediaOutput)lastElement);
        } else if (this.isBranch(lastElement)) {
            MediaBranch local2 = (MediaBranch)lastElement;
            for (MediaTrack local3 : local2.getTracks()) {
                if (local3 == null) continue;
                ArrayListExtensions.addRange(outputs, local3.getOutputs());
            }
        }
        return this.arrayFromOutputs(outputs);
    }

    @Override
    public String getPipelineJson() {
        TIElement firstElement = this.getFirstElement();
        if (firstElement != null) {
            return firstElement.getPipelineJson();
        }
        return "null";
    }

    public TSink getSink() {
        TIElement lastElement = this.getLastElement();
        if (lastElement != null && this.isSink(lastElement)) {
            return (TSink)((MediaSink)lastElement);
        }
        return null;
    }

    @Override
    public SinkOutput getSinkOutput() {
        TSink sink = this.getSink();
        if (sink != null) {
            return ((MediaSink)sink).getOutput();
        }
        return null;
    }

    @Override
    public Future<SinkOutput[]> getSinkOutputs() {
        TSink sink = this.getSink();
        if (sink != null) {
            return ((MediaSink)sink).getOutputs();
        }
        Promise<SinkOutput[]> promise = new Promise<SinkOutput[]>();
        promise.resolve(new SinkOutput[0]);
        return promise;
    }

    public TSource getSource() {
        TIElement firstElement = this.getFirstElement();
        if (firstElement != null && this.isSource(firstElement)) {
            return (TSource)((MediaSource)firstElement);
        }
        return null;
    }

    @Override
    public SourceInput getSourceInput() {
        TSource source = this.getSource();
        if (source != null) {
            return ((MediaSource)source).getInput();
        }
        return null;
    }

    @Override
    public Future<SourceInput[]> getSourceInputs() {
        TSource source = this.getSource();
        if (source != null) {
            return ((MediaSource)source).getInputs();
        }
        Promise<SourceInput[]> promise = new Promise<SourceInput[]>();
        promise.resolve(new SourceInput[0]);
        return promise;
    }

    protected abstract boolean isBranch(TIElement var1);

    protected abstract boolean isInput(TIElement var1);

    protected abstract boolean isOutput(TIElement var1);

    protected abstract boolean isPipe(TIElement var1);

    protected abstract boolean isSink(TIElement var1);

    protected abstract boolean isSource(TIElement var1);

    protected abstract boolean isStream(TIElement var1);

    public MediaTrack() {
        this.setId(Guid.newGuid().toString().replace("-", ""));
    }

    public TTrack next(TBranch branch) {
        if (branch != null) {
            if (this.getIsBranched()) {
                throw new RuntimeException(new Exception("Cannot branch a branched track. Try merging first."));
            }
            if (this.getIsTerminated()) {
                throw new RuntimeException(new Exception("Cannot branch a terminated track."));
            }
            if (!this.getIsEmpty()) {
                for (MediaTrack local : branch.getTracks()) {
                    if (local == null || local.getIsEmpty()) continue;
                    ((IMediaOutput)this.getLastElement()).addOutput((IMediaInput)local.getFirstElement());
                }
            }
            this.addElement(branch);
        }
        return (TTrack)this;
    }

    public TTrack next(TTrack[] tracks) {
        return this.next((TIInput)this.branchFromTracks((MediaTrack[])tracks));
    }

    public TTrack next(TIInput next) {
        if (next != null) {
            if (this.isStream(next)) {
                throw new RuntimeException(new Exception("A stream cannot belong to a media track."));
            }
            if (this.getIsTerminated()) {
                throw new RuntimeException(new Exception("Cannot add to a terminated track."));
            }
            if (!this.getIsEmpty()) {
                if (this.getIsBranched()) {
                    this.addToBranch((MediaBranch)this.getLastElement(), next);
                } else {
                    ((IMediaOutput)this.getLastElement()).addOutput(next);
                }
            }
            this.addElement(next);
        }
        return (TTrack)this;
    }

    @Override
    public void setId(String value) {
        this._id = value;
    }

    @Override
    public void setMuted(boolean value) {
        for (IMediaElement local : this.getElements()) {
            local.setMuted(value);
        }
    }

    @Override
    public void setSinkOutput(SinkOutput value) {
        TSink sink = this.getSink();
        if (sink != null) {
            ((MediaSink)sink).setOutput(value);
        }
    }

    @Override
    public void setSourceInput(SourceInput value) {
        TSource source = this.getSource();
        if (source != null) {
            ((MediaSource)source).setInput(value);
        }
    }
}

