/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.Global;
import fm.icelink.LinkedListEnumerator;
import fm.icelink.LinkedListNode;
import java.util.ArrayList;

public class LinkedList<T> {
    private int __count;
    private LinkedListNode<T> _first;
    private LinkedListNode<T> _last;

    public LinkedListNode<T> addAfterNode(LinkedListNode<T> node, T value) {
        if (node == null) {
            throw new RuntimeException(new Exception("Node cannot be null."));
        }
        LinkedListNode<T> node3 = new LinkedListNode<T>(value);
        node3.setPrevious(node);
        node3.setNext(node.getNext());
        LinkedListNode<T> node2 = node3;
        if (node.getNext() != null) {
            node.getNext().setPrevious(node2);
        }
        node.setNext(node2);
        if (node2.getNext() == null) {
            this.setLast(node2);
        }
        ++this.__count;
        return node2;
    }

    public LinkedListNode<T> addFirst(T value) {
        if (this.getFirst() == null) {
            this.setFirst(new LinkedListNode<T>(value));
            this.setLast(this.getFirst());
        } else {
            LinkedListNode<T> first = this.getFirst();
            this.setFirst(new LinkedListNode<T>(value));
            this.getFirst().setNext(first);
            first.setPrevious(this.getFirst());
        }
        ++this.__count;
        return this.getFirst();
    }

    public void addLast(T value) {
        if (this.getFirst() == null) {
            this.setFirst(new LinkedListNode<T>(value));
            this.setLast(this.getFirst());
        } else {
            LinkedListNode<T> last = this.getLast();
            last.setNext(new LinkedListNode<T>(value));
            this.setLast(last.getNext());
            this.getLast().setPrevious(last);
        }
        ++this.__count;
    }

    public void clear() {
        this.setFirst(null);
        this.setLast(null);
        this.__count = 0;
    }

    public int getCount() {
        return this.__count;
    }

    public LinkedListEnumerator<T> getEnumerator() {
        return new LinkedListEnumerator<T>(this.getFirst());
    }

    public LinkedListNode<T> getFirst() {
        return this._first;
    }

    public LinkedListNode<T> getLast() {
        return this._last;
    }

    public void remove(T value) {
        LinkedListEnumerator<T> enumerator = this.getEnumerator();
        while (enumerator.moveNext()) {
            if (enumerator.getCurrent() != value) continue;
            this.removeNode(enumerator.getCurrentNode());
            break;
        }
    }

    public void removeFirst() {
        if (this.getFirst() != null) {
            this.setFirst(this.getFirst().getNext());
            if (this.getFirst() == null) {
                this.setLast(null);
            }
            --this.__count;
        }
    }

    public void removeNode(LinkedListNode<T> node) {
        LinkedListNode<T> previous = node.getPrevious();
        LinkedListNode<T> next = node.getNext();
        if (Global.equals(this.getFirst(), node)) {
            this.setFirst(next);
        }
        if (Global.equals(this.getLast(), node)) {
            this.setLast(previous);
        }
        if (next != null) {
            next.setPrevious(previous);
        }
        if (previous != null) {
            previous.setNext(next);
        }
        node.setNext(null);
        node.setPrevious(null);
        --this.__count;
    }

    private void setFirst(LinkedListNode<T> value) {
        this._first = value;
    }

    private void setLast(LinkedListNode<T> value) {
        this._last = value;
    }

    public ArrayList<T> toList() {
        ArrayList<T> list = new ArrayList<T>();
        LinkedListEnumerator<T> enumerator = this.getEnumerator();
        while (enumerator.moveNext()) {
            list.add(enumerator.getCurrent());
        }
        return list;
    }
}

