/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.DataBuffer;
import fm.icelink.HashContext;
import fm.icelink.HashType;
import fm.icelink.Utf8;

public abstract class HashContextBase {
    private HashType _type;

    public DataBuffer compute(String inputString) {
        return this.doCompute(DataBuffer.wrap(Utf8.encode(inputString)));
    }

    public DataBuffer compute(DataBuffer input) {
        return this.doCompute(input);
    }

    public static DataBuffer compute(HashType type, DataBuffer input) {
        HashContext context = new HashContext(type);
        DataBuffer buffer = context.compute(input);
        context.destroy();
        return buffer;
    }

    public static DataBuffer compute(HashType type, String inputString) {
        HashContext context = new HashContext(type);
        DataBuffer buffer = context.compute(inputString);
        context.destroy();
        return buffer;
    }

    public void destroy() {
        this.doDestroy();
    }

    protected abstract DataBuffer doCompute(DataBuffer var1);

    protected abstract void doDestroy();

    public HashType getType() {
        return this._type;
    }

    public HashContextBase(HashType type) {
        this.setType(type);
    }

    private void setType(HashType value) {
        this._type = value;
    }
}

