/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayExtensions;
import fm.icelink.CoreTransport;
import fm.icelink.DataChannel;
import fm.icelink.DataChannelCollection;
import fm.icelink.DataChannelStats;
import fm.icelink.DataStreamBase;
import fm.icelink.DataStreamStats;
import fm.icelink.DateExtensions;
import fm.icelink.Error;
import fm.icelink.ErrorCode;
import fm.icelink.Global;
import fm.icelink.ReliableTransport;
import fm.icelink.SctpTransport;
import fm.icelink.StreamDirection;
import fm.icelink.StringExtensions;
import fm.icelink.sdp.DirectionAttribute;
import fm.icelink.sdp.Media;
import fm.icelink.sdp.MediaDescription;
import fm.icelink.sdp.MediaType;
import fm.icelink.sdp.Message;
import fm.icelink.sdp.sctp.MapAttribute;
import fm.icelink.sdp.sctp.MaxMessageSizeAttribute;
import java.util.ArrayList;

public class DataStream
extends DataStreamBase<DataChannel> {
    private DataChannelCollection __channels = new DataChannelCollection();
    private ReliableTransport _reliableDataTransport;
    private SctpTransport _sctpTransport;

    @Override
    public MediaDescription createSdpMediaDescription(Message sdpMessage, boolean supportSdes, boolean isOffer, boolean renegotiation) {
        MediaDescription description = super.createSdpMediaDescription(sdpMessage, false, isOffer, renegotiation);
        if (super.getLocalDtlsParameters() == null) {
            throw new RuntimeException(new Exception("Dtls is mandatory for Data Streams, but local Dtls parameters were not set prior to signalling exchnage."));
        }
        Media media = description.getMedia();
        media.setTransportProtocol(fm.icelink.sdp.sctp.Media.getDtlsSctpTransportProtocol());
        media.setFormatDescription("5000");
        media.setMediaType(MediaType.getApplication());
        int streams = ArrayExtensions.getLength(this.getChannels()) * 2 + 1;
        description.addMediaAttribute(new MapAttribute(this.getSctpPort(), fm.icelink.sdp.sctp.Media.getWebRtcDatachannelAssociationUsage(), streams));
        DirectionAttribute attribute = DirectionAttribute.generateDirectionAttribute(StreamDirection.SendReceive);
        description.addMediaAttribute(attribute);
        return description;
    }

    public DataStream(DataChannel channel) {
        this(new DataChannel[]{channel});
    }

    public DataStream(DataChannel[] channels) {
        this.__channels.addMany(channels);
    }

    public DataChannel[] getChannels() {
        return (DataChannel[])this.__channels.getValues();
    }

    ReliableTransport getReliableDataTransport() {
        return this._reliableDataTransport;
    }

    public int getSctpPort() {
        if (this.getSctpTransport() != null) {
            return this.getSctpTransport().getLocalPort();
        }
        return 5000;
    }

    SctpTransport getSctpTransport() {
        return this._sctpTransport;
    }

    DataStreamStats getStats() {
        ArrayList<DataChannelStats> list = new ArrayList<DataChannelStats>();
        for (DataChannel channel : this.getChannels()) {
            list.add(channel.getStats());
        }
        DataStreamStats stats2 = new DataStreamStats();
        stats2.setId(super.getId());
        stats2.setTimestamp(DateExtensions.getUtcNow());
        stats2.setType(super.getType());
        stats2.setDataChannels(list.toArray(new DataChannelStats[0]));
        DataStreamStats stats = stats2;
        CoreTransport coreTransportRtp = super.getCoreTransportRtp();
        if (coreTransportRtp != null) {
            stats.setTransport(coreTransportRtp.getStats());
        }
        return stats;
    }

    @Override
    protected void processCachedSettings() {
        super.processCachedSettings();
    }

    @Override
    Error processSdpMediaDescription(Message sdpMessage, MediaDescription sdpMediaDescription, boolean isLocalDescription, boolean isOffer, boolean isRenegotiation) {
        Error error = super.processSdpMediaDescription(sdpMessage, sdpMediaDescription, isLocalDescription, isOffer, isRenegotiation);
        if (error == null) {
            MaxMessageSizeAttribute sctpMaxMessageSizeAttribute;
            StreamDirection streamDirection = sdpMediaDescription.getStreamDirection();
            if (Global.equals((Object)streamDirection, (Object)StreamDirection.Unset)) {
                streamDirection = sdpMessage.getSessionLevelDirection();
            }
            if (Global.equals((Object)streamDirection, (Object)StreamDirection.Unset)) {
                streamDirection = StreamDirection.SendReceive;
            }
            if (!Global.equals((Object)streamDirection, (Object)StreamDirection.SendReceive)) {
                Error error2 = new Error(ErrorCode.StreamDirectionMismatch);
                error2.setException(new Exception(StringExtensions.format("Data streams only support SendReceive direction; however, remote peer supplied {0} direction.", streamDirection.toString())));
                return error2;
            }
            if (!super.getUseDtls()) {
                Error error3 = new Error(ErrorCode.StreamEncryptionMismatch);
                error3.setException(new Exception("Data streams must use Dtls encryption; however, the remote peer does not support it."));
                return error3;
            }
            String webRtcDatachannelAssociationUsage = fm.icelink.sdp.sctp.Media.getWebRtcDatachannelAssociationUsage();
            int streams = 65535;
            int port = 5000;
            long maxMessageSize = 65535L;
            MapAttribute sctpMapAttribute = sdpMediaDescription.getSctpMapAttribute();
            if (sctpMapAttribute != null) {
                webRtcDatachannelAssociationUsage = sctpMapAttribute.getSctpProtocol();
                streams = sctpMapAttribute.getStreams();
                port = sctpMapAttribute.getPort();
            }
            if ((sctpMaxMessageSizeAttribute = sdpMediaDescription.getSctpMaxMessageSizeAttribute()) != null) {
                maxMessageSize = sctpMaxMessageSizeAttribute.getMaxMessageSize();
            }
        }
        return error;
    }

    @Override
    void reset() {
        super.reset();
        this.setSctpTransport(null);
        this.setReliableDataTransport(null);
        for (DataChannel channel : this.getChannels()) {
            channel.reset();
        }
    }

    void setReliableDataTransport(ReliableTransport value) {
        this._reliableDataTransport = value;
    }

    void setSctpTransport(SctpTransport value) {
        this._sctpTransport = value;
    }
}

