/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.DataBuffer;
import fm.icelink.DataChannelReceiveArgs;
import fm.icelink.DataChannelState;
import fm.icelink.Dynamic;
import fm.icelink.Global;
import fm.icelink.Guid;
import fm.icelink.IAction1;
import fm.icelink.IActionDelegate1;
import fm.icelink.IDataChannel;
import java.util.ArrayList;
import java.util.List;

public abstract class DataChannelBase<TDataChannel>
extends Dynamic
implements IDataChannel<TDataChannel> {
    private List<IAction1<TDataChannel>> __onStateChange = new ArrayList<IAction1<TDataChannel>>();
    private DataChannelState __state;
    private String _id;
    private String _label;
    private IAction1<DataChannelReceiveArgs> _onReceive;
    private IAction1<TDataChannel> _onStateChange = new IAction1<TDataChannel>(){

        @Override
        public void invoke(TDataChannel p0) {
            for (IAction1 action : new ArrayList(DataChannelBase.this.__onStateChange)) {
                action.invoke(p0);
            }
        }
    };
    private boolean _ordered;
    Object _stateLock = new Object();
    private String _subprotocol;

    @Override
    public void addOnStateChange(IAction1<TDataChannel> value) {
        this.__onStateChange.add(value);
    }

    public DataChannelBase(String label, boolean ordered, String subprotocol) {
        this.setId(Guid.newGuid().toString().replace("-", ""));
        this.setState(DataChannelState.New);
        this.setLabel(label);
        this.setOrdered(ordered);
        this.setSubprotocol(subprotocol);
    }

    public String getId() {
        return this._id;
    }

    protected abstract TDataChannel getInstance();

    @Override
    public String getLabel() {
        return this._label;
    }

    @Override
    public IAction1<DataChannelReceiveArgs> getOnReceive() {
        return this._onReceive;
    }

    @Override
    public boolean getOrdered() {
        return this._ordered;
    }

    @Override
    public DataChannelState getState() {
        return this.__state;
    }

    @Override
    public String getSubprotocol() {
        return this._subprotocol;
    }

    protected void raiseDataBytes(DataBuffer dataBytes) {
        IAction1<DataChannelReceiveArgs> onReceive = this.getOnReceive();
        if (onReceive != null) {
            DataChannelReceiveArgs p = new DataChannelReceiveArgs();
            p.setDataBytes(dataBytes);
            onReceive.invoke(p);
        }
    }

    protected void raiseDataString(String dataString) {
        IAction1<DataChannelReceiveArgs> onReceive = this.getOnReceive();
        if (onReceive != null) {
            DataChannelReceiveArgs p = new DataChannelReceiveArgs();
            p.setDataString(dataString);
            onReceive.invoke(p);
        }
    }

    @Override
    public void removeOnStateChange(IAction1<TDataChannel> value) {
        IAction1 match;
        if (value instanceof IActionDelegate1 && (match = Global.findIActionDelegate1WithId(this.__onStateChange, ((IActionDelegate1)value).getId())) != null) {
            value = match;
        }
        this.__onStateChange.remove(value);
    }

    @Override
    public abstract void sendDataBytes(DataBuffer var1);

    @Override
    public abstract void sendDataString(String var1);

    public void setId(String value) {
        this._id = value;
    }

    private void setLabel(String value) {
        this._label = value;
    }

    @Override
    public void setOnReceive(IAction1<DataChannelReceiveArgs> value) {
        this._onReceive = value;
    }

    private void setOrdered(boolean value) {
        this._ordered = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setState(DataChannelState value) {
        Object object = this._stateLock;
        synchronized (object) {
            if (!Global.equals((Object)this.__state, (Object)value)) {
                this.__state = value;
                IAction1<TDataChannel> onStateChange = this._onStateChange;
                if (onStateChange != null) {
                    onStateChange.invoke(this.getInstance());
                }
            }
        }
    }

    private void setSubprotocol(String value) {
        this._subprotocol = value;
    }
}

