/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayExtensions;
import fm.icelink.Ascii;
import fm.icelink.DataBuffer;
import fm.icelink.MathAssistant;
import fm.icelink.MediaControlFrame;

public class AppControlFrame
extends MediaControlFrame {
    public AppControlFrame(DataBuffer buffer) {
        super(buffer);
        super.setPayloadType(AppControlFrame.getRegisteredPayloadType());
    }

    public AppControlFrame() {
        this(DataBuffer.allocate(MediaControlFrame.getFixedHeaderLength() + AppControlFrame.getFixedPayloadHeaderLength()));
        super.setPayloadLengthWithPadding(AppControlFrame.getFixedPayloadHeaderLength());
    }

    public AppControlFrame(int subType, long synchronizationSource, String name, DataBuffer data) {
        this(DataBuffer.allocate(MediaControlFrame.getFixedHeaderLength() + AppControlFrame.getFixedPayloadHeaderLength() + data.getLength()));
        super.setByte1Last5Bits(subType);
        this.setSynchronizationSource(synchronizationSource);
        this.setName(name);
        this.setData(data);
        super.setPayloadLengthWithPadding(AppControlFrame.getFixedPayloadHeaderLength() + data.getLength());
    }

    public DataBuffer getData() {
        return super.getDataBuffer().subset(this.getDataPayloadOffset(), super.getPayload().getLength() - AppControlFrame.getFixedPayloadHeaderLength());
    }

    public int getDataLength() {
        return this.getData().getLength();
    }

    public int getDataPayloadOffset() {
        return MediaControlFrame.getFixedHeaderLength() + AppControlFrame.getFixedPayloadHeaderLength();
    }

    public static int getFixedPayloadHeaderLength() {
        return 8;
    }

    public String getName() {
        return Ascii.decode(super.getDataBuffer().subset(8, 4).toArray());
    }

    public static int getRegisteredPayloadType() {
        return 204;
    }

    public int getSubType() {
        return super.getByte1Last5Bits();
    }

    public long getSynchronizationSource() {
        return super.getDataBuffer().read32(4);
    }

    private void setData(DataBuffer value) {
        super.getDataBuffer().write(value, this.getDataPayloadOffset());
    }

    public void setName(String value) {
        super.getDataBuffer().write32(0L, 8);
        if (value != null) {
            byte[] data = Ascii.encode(value);
            DataBuffer buffer = DataBuffer.wrap(data, 0, MathAssistant.min(ArrayExtensions.getLength(data), 4));
            super.getDataBuffer().write(buffer, 8);
        }
    }

    public void setSubType(int value) {
        super.setByte1Last5Bits(value);
    }

    public void setSynchronizationSource(long value) {
        super.getDataBuffer().write32(value, 4);
    }
}

