/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.AecPipe;
import fm.icelink.AudioConfig;
import fm.icelink.AudioMixer;
import fm.icelink.AudioPipe;
import fm.icelink.AudioSink;

public abstract class AecContext {
    private AudioPipe _outputMixer;
    private AudioSink _outputMixerSink;
    private AecPipe _processor;

    public AecContext() {
        this.setProcessor(this.createProcessor());
        if (this.getProcessor() == null) {
            throw new RuntimeException(new Exception("AEC processor cannot be null."));
        }
        this.setOutputMixerSink(this.createOutputMixerSink(this.getProcessor().getConfig()));
        if (this.getOutputMixerSink() == null) {
            throw new RuntimeException(new Exception("AEC output mixer sink cannot be null."));
        }
        this.setOutputMixer(this.createOutputMixer(this.getProcessor().getConfig()));
        if (this.getOutputMixer() == null) {
            throw new RuntimeException(new Exception("AEC output mixer cannot be null."));
        }
        this.getOutputMixer().addOutput(this.getOutputMixerSink());
        this.getProcessor().setSpeaker(this.getOutputMixerSink());
    }

    protected AudioPipe createOutputMixer(AudioConfig config) {
        return new AudioMixer(config);
    }

    protected abstract AudioSink createOutputMixerSink(AudioConfig var1);

    protected abstract AecPipe createProcessor();

    public void destroy() {
        if (this.getProcessor() != null) {
            this.getProcessor().destroy();
            this.setProcessor(null);
        }
        if (this.getOutputMixer() != null) {
            this.getOutputMixer().destroy();
            this.setOutputMixer(null);
        }
        if (this.getOutputMixerSink() != null) {
            this.getOutputMixerSink().destroy();
            this.setOutputMixerSink(null);
        }
    }

    public AudioConfig getConfig() {
        return this.getProcessor().getConfig();
    }

    public AudioPipe getOutputMixer() {
        return this._outputMixer;
    }

    public AudioSink getOutputMixerSink() {
        return this._outputMixerSink;
    }

    public AecPipe getProcessor() {
        return this._processor;
    }

    private void setOutputMixer(AudioPipe value) {
        this._outputMixer = value;
    }

    private void setOutputMixerSink(AudioSink value) {
        this._outputMixerSink = value;
    }

    private void setProcessor(AecPipe value) {
        this._processor = value;
    }
}

