/*
 * Decompiled with CFR 0.152.
 */
package fm.websync;

import fm.ArrayExtensions;
import fm.Guid;
import fm.NullableGuid;
import fm.Serializer;
import fm.websync.BaseMessage;
import fm.websync.Message;

public class Notification
extends BaseMessage {
    public static Notification fromJson(String notificationJson) throws Exception {
        return fm.websync.Serializer.deserializeNotification(notificationJson);
    }

    public static Notification[] fromJsonMultiple(String notificationsJson) throws Exception {
        return fm.websync.Serializer.deserializeNotificationArray(notificationsJson);
    }

    public static Notification fromMessage(Message message) throws Exception {
        if (message == null) {
            return null;
        }
        Notification notification = new Notification();
        notification.setClientId(message.getNotifyClientId().getValue());
        notification.setSuccessful(message.getSuccessful());
        notification.setError(message.getError());
        notification.setTimestamp(message.getTimestamp());
        notification.setDataJson(message.getDataJson());
        notification.setExtensions(message.getExtensions());
        return notification;
    }

    public static Notification[] fromMessages(Message[] messages) throws Exception {
        if (messages == null) {
            return null;
        }
        Notification[] notificationArray = new Notification[ArrayExtensions.getLength((Object[])messages)];
        for (int i = 0; i < ArrayExtensions.getLength((Object[])messages); ++i) {
            notificationArray[i] = Notification.fromMessage(messages[i]);
        }
        return notificationArray;
    }

    public Guid getClientId() throws Exception {
        NullableGuid nullable = Serializer.deserializeGuid((String)super.getExtensionValueJson("fm.notify"));
        if (nullable.getHasValue()) {
            return nullable.getValue();
        }
        return Guid.empty;
    }

    public String getTag() throws Exception {
        return Serializer.deserializeString((String)super.getExtensionValueJson("fm.tag"));
    }

    public Notification() {
    }

    public Notification(Guid clientId) throws Exception {
        this.setClientId(clientId);
    }

    public Notification(Guid clientId, String dataJson) throws Exception {
        this(clientId, dataJson, null);
    }

    public Notification(Guid clientId, String dataJson, String tag) throws Exception {
        this.setClientId(clientId);
        super.setDataJson(dataJson);
        this.setTag(tag);
    }

    public Notification(Guid clientId, byte[] dataBytes) throws Exception {
        this(clientId, dataBytes, null);
    }

    public Notification(Guid clientId, byte[] dataBytes, String tag) throws Exception {
        this.setClientId(clientId);
        super.setDataBytes(dataBytes);
        this.setTag(tag);
    }

    public void setClientId(Guid value) throws Exception {
        super.setExtensionValueJson("fm.notify", Serializer.serializeGuid((NullableGuid)new NullableGuid(value)), false);
        super.setIsDirty(true);
    }

    public void setTag(String value) throws Exception {
        super.setExtensionValueJson("fm.tag", Serializer.serializeString((String)value), false);
        super.setIsDirty(true);
    }

    public String toJson() {
        return Notification.toJson(this);
    }

    public static String toJson(Notification notification) {
        return fm.websync.Serializer.serializeNotification(notification);
    }

    public static String toJsonMultiple(Notification[] notifications) {
        return fm.websync.Serializer.serializeNotificationArray(notifications);
    }

    public static Message toMessage(Notification notification) throws Exception {
        if (notification == null) {
            return null;
        }
        Message message = new Message("/meta/notify");
        message.setNotifyClientId(new NullableGuid(notification.getClientId()));
        message.setSuccessful(notification.getSuccessful());
        message.setError(notification.getError());
        message.setTimestamp(notification.getTimestamp());
        message.setDataJson(notification.getDataJson());
        message.setExtensions(notification.getExtensions());
        return message;
    }

    public static Message[] toMessages(Notification[] notifications) throws Exception {
        if (notifications == null) {
            return null;
        }
        Message[] messageArray = new Message[ArrayExtensions.getLength((Object[])notifications)];
        for (int i = 0; i < ArrayExtensions.getLength((Object[])notifications); ++i) {
            messageArray[i] = Notification.toMessage(notifications[i]);
        }
        return messageArray;
    }
}

