/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.vpx;

import fm.icelink.DataBuffer;
import fm.icelink.Global;
import fm.icelink.IntegerExtensions;
import fm.icelink.Log;
import fm.icelink.MathAssistant;
import fm.icelink.MediaBuffer;
import fm.icelink.StringExtensions;
import fm.icelink.VideoBuffer;
import fm.icelink.VideoEncoder;
import fm.icelink.VideoFormat;
import fm.icelink.VideoFrame;
import fm.icelink.vp8.Utility;
import fm.icelink.vpx.Codec;
import fm.icelink.vpx.Native;

public abstract class Encoder
extends VideoEncoder {
    private Native __encoder = Global.equals((Object)((VideoFormat)super.getOutputFormat()).getName(), (Object)VideoFormat.getVp9Name()) ? new Native(true) : new Native(true);
    private int __userSetBitrate = -1;

    protected void doDestroy() {
        this.__encoder.destroy();
        this.__encoder = null;
    }

    protected void doProcessFrame(VideoFrame frame, VideoBuffer inputBuffer) {
        VideoBuffer buffer;
        int maxOutputBitrate = this.getMaxOutputBitrate();
        if (maxOutputBitrate > 0 && maxOutputBitrate != this.__encoder.getBitrate()) {
            Log.debug((String)StringExtensions.concat((String)"Changing VPX encoder bitrate from ", (String)IntegerExtensions.toString((Integer)this.__encoder.getBitrate()), (String)" to ", (String)IntegerExtensions.toString((Integer)maxOutputBitrate)));
            this.__encoder.setBitrate(maxOutputBitrate);
        }
        if ((buffer = this.__encoder.encode(inputBuffer, (VideoFormat)super.getOutputFormat())) != null) {
            if (Utility.isKeyFrame((DataBuffer)buffer.getDataBuffer())) {
                Log.debug((String)"Encoder generated VP8 keyframe.");
            }
            frame.addBuffer((MediaBuffer)buffer);
            this.raiseFrame(frame);
            buffer.getDataBuffer().free();
        }
    }

    public Encoder(VideoFormat outputFormat) {
        super(VideoFormat.getI420(), outputFormat);
    }

    public int getBitrate() {
        return this.__encoder.getBitrate();
    }

    public Codec getCodec() {
        return this.__encoder.getCodec();
    }

    public boolean getForceKeyFrame() {
        return this.__encoder.getForceKeyFrame();
    }

    public int getMaxOutputBitrate() {
        int maxOutputBitrate = super.getMaxOutputBitrate();
        return this.__userSetBitrate < 0 ? maxOutputBitrate : (maxOutputBitrate < 0 ? this.__userSetBitrate : MathAssistant.min((int)this.__userSetBitrate, (int)maxOutputBitrate));
    }

    public double getQuality() {
        return this.__encoder.getQuality();
    }

    protected abstract boolean isKeyFrame(DataBuffer var1);

    public void setBitrate(int value) {
        this.__userSetBitrate = value;
        this.__encoder.setBitrate(this.__userSetBitrate);
    }

    public void setCodec(Codec value) {
        this.__encoder.setCodec(value);
    }

    public void setForceKeyFrame(boolean value) {
        this.__encoder.setForceKeyFrame(value);
    }

    public void setQuality(double value) {
        this.__encoder.setQuality(value);
    }
}

