/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator.jcajce;

import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.Provider;
import java.security.Signature;
import java.security.SignatureException;
import org.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import org.bouncycastle.jcajce.util.NamedJcaJceHelper;
import org.bouncycastle.jcajce.util.ProviderJcaJceHelper;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPRuntimeOperationException;
import org.bouncycastle.openpgp.operator.PGPContentVerifier;
import org.bouncycastle.openpgp.operator.PGPContentVerifierBuilder;
import org.bouncycastle.openpgp.operator.PGPContentVerifierBuilderProvider;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPKeyConverter;
import org.bouncycastle.openpgp.operator.jcajce.OperatorHelper;
import org.bouncycastle.openpgp.operator.jcajce.SignatureOutputStream;

public class JcaPGPContentVerifierBuilderProvider
implements PGPContentVerifierBuilderProvider {
    private OperatorHelper helper = new OperatorHelper(new DefaultJcaJceHelper());
    private JcaPGPKeyConverter keyConverter = new JcaPGPKeyConverter();

    public JcaPGPContentVerifierBuilderProvider setProvider(Provider provider) {
        this.helper = new OperatorHelper(new ProviderJcaJceHelper(provider));
        this.keyConverter.setProvider(provider);
        return this;
    }

    public JcaPGPContentVerifierBuilderProvider setProvider(String providerName) {
        this.helper = new OperatorHelper(new NamedJcaJceHelper(providerName));
        this.keyConverter.setProvider(providerName);
        return this;
    }

    @Override
    public PGPContentVerifierBuilder get(int keyAlgorithm, int hashAlgorithm) throws PGPException {
        return new JcaPGPContentVerifierBuilder(keyAlgorithm, hashAlgorithm);
    }

    private class JcaPGPContentVerifierBuilder
    implements PGPContentVerifierBuilder {
        private int hashAlgorithm;
        private int keyAlgorithm;

        public JcaPGPContentVerifierBuilder(int keyAlgorithm, int hashAlgorithm) {
            this.keyAlgorithm = keyAlgorithm;
            this.hashAlgorithm = hashAlgorithm;
        }

        @Override
        public PGPContentVerifier build(final PGPPublicKey publicKey) throws PGPException {
            final Signature signature = JcaPGPContentVerifierBuilderProvider.this.helper.createSignature(this.keyAlgorithm, this.hashAlgorithm);
            try {
                signature.initVerify(JcaPGPContentVerifierBuilderProvider.this.keyConverter.getPublicKey(publicKey));
            }
            catch (InvalidKeyException e) {
                throw new PGPException("invalid key.", e);
            }
            return new PGPContentVerifier(){

                @Override
                public int getHashAlgorithm() {
                    return JcaPGPContentVerifierBuilder.this.hashAlgorithm;
                }

                @Override
                public int getKeyAlgorithm() {
                    return JcaPGPContentVerifierBuilder.this.keyAlgorithm;
                }

                @Override
                public long getKeyID() {
                    return publicKey.getKeyID();
                }

                @Override
                public boolean verify(byte[] expected) {
                    try {
                        return signature.verify(expected);
                    }
                    catch (SignatureException e) {
                        throw new PGPRuntimeOperationException("unable to verify signature: " + e.getMessage(), e);
                    }
                }

                @Override
                public OutputStream getOutputStream() {
                    return new SignatureOutputStream(signature);
                }
            };
        }
    }
}

