/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.sdp.ice;

import fm.icelink.IntegerExtensions;
import fm.icelink.ParseAssistant;
import fm.icelink.StringBuilderExtensions;
import fm.icelink.StringExtensions;

public class RemoteCandidate {
    private int _componentId;
    private String _connectionAddress;
    private int _port;

    public int getComponentId() {
        return this._componentId;
    }

    public String getConnectionAddress() {
        return this._connectionAddress;
    }

    public int getPort() {
        return this._port;
    }

    public static RemoteCandidate parse(String s) {
        String[] strArray = StringExtensions.split(s, new char[]{' '});
        int componentId = ParseAssistant.parseIntegerValue(strArray[0]);
        String connectionAddress = strArray[1];
        return new RemoteCandidate(componentId, connectionAddress, ParseAssistant.parseIntegerValue(strArray[2]));
    }

    public RemoteCandidate(int componentId, String connectionAddress, int port) {
        if (connectionAddress == null) {
            throw new RuntimeException(new Exception("connectionAddress cannot be null."));
        }
        this.setComponentId(componentId);
        this.setConnectionAddress(connectionAddress);
        this.setPort(port);
    }

    private void setComponentId(int value) {
        this._componentId = value;
    }

    private void setConnectionAddress(String value) {
        this._connectionAddress = value;
    }

    private void setPort(int value) {
        this._port = value;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        StringBuilderExtensions.append(builder, IntegerExtensions.toString(this.getComponentId()));
        StringBuilderExtensions.append(builder, " ");
        StringBuilderExtensions.append(builder, this.getConnectionAddress());
        StringBuilderExtensions.append(builder, " ");
        StringBuilderExtensions.append(builder, IntegerExtensions.toString(this.getPort()));
        return builder.toString();
    }
}

