/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.matroska;

import fm.icelink.ArrayExtensions;
import fm.icelink.BitAssistant;
import fm.icelink.ByteOutputStream;
import fm.icelink.IntegerHolder;
import fm.icelink.Log;
import fm.icelink.StringExtensions;
import fm.icelink.matroska.Element;

public class ContentCompression
extends Element {
    private long _contentCompAlgo;
    private static byte[] _contentCompAlgoId = new byte[]{66, 84};
    private byte[] _contentCompSettings;
    private static byte[] _contentCompSettingsId = new byte[]{66, 85};

    public ContentCompression() {
    }

    public ContentCompression(byte[] bytes) {
        this();
        int offset = 0;
        while (offset < ArrayExtensions.getLength(bytes)) {
            IntegerHolder _var0 = new IntegerHolder(offset);
            byte[] _var1 = Element.readId(bytes, offset, _var0);
            offset = _var0.getValue();
            byte[] buffer = _var1;
            IntegerHolder _var2 = new IntegerHolder(offset);
            byte[] _var3 = Element.readValue(bytes, offset, _var2);
            offset = _var2.getValue();
            byte[] buffer2 = _var3;
            if (Element.compare(buffer, _contentCompAlgoId)) {
                this.setContentCompAlgo(Element.readUnsignedInteger(buffer2));
                continue;
            }
            if (Element.compare(buffer, _contentCompSettingsId)) {
                this.setContentCompSettings(buffer2);
                continue;
            }
            Log.warn(StringExtensions.concat("Unrecognized ID in MatroskaContentCompression: ", BitAssistant.getHexString(buffer)));
        }
    }

    public long getContentCompAlgo() {
        return this._contentCompAlgo;
    }

    public byte[] getContentCompSettings() {
        return this._contentCompSettings;
    }

    public static long getDefaultContentCompAlgo() {
        return 0L;
    }

    public static byte[] getEbmlId() {
        return new byte[]{80, 52};
    }

    @Override
    public byte[] getId() {
        return ContentCompression.getEbmlId();
    }

    @Override
    protected byte[] getInnerBytes() {
        ByteOutputStream stream = new ByteOutputStream();
        if (super.getWriteDefaultValues() || this.getContentCompAlgo() != ContentCompression.getDefaultContentCompAlgo()) {
            super.writeUnsignedInteger(this.getContentCompAlgo(), _contentCompAlgoId, stream);
        }
        if (this.getContentCompSettings() != null) {
            super.write(this.getContentCompSettings(), _contentCompSettingsId, stream);
        }
        return stream.toArray();
    }

    public void setContentCompAlgo(long value) {
        this._contentCompAlgo = value;
    }

    public void setContentCompSettings(byte[] value) {
        this._contentCompSettings = value;
    }
}

