/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayExtensions;
import fm.icelink.Binary;
import fm.icelink.DataBuffer;
import fm.icelink.DataBufferPool;
import fm.icelink.IntegerHolder;
import fm.icelink.SctpChunkType;
import fm.icelink.SctpControlChunk;

class SctpForwardTsnChunk
extends SctpControlChunk {
    private long _newCumulativeTsnAck;
    private int[][] _streamStreamSequencePairs;
    public static int _unset = -1;

    public static byte[] getBytes(SctpForwardTsnChunk chunk, int sizeLimit) {
        int[][] streamStreamSequencePairs = chunk.getStreamStreamSequencePairs();
        int num = streamStreamSequencePairs == null ? 0 : ArrayExtensions.getLength((Object[])streamStreamSequencePairs);
        int size = 8 + num * 4;
        if (sizeLimit != _unset && size > sizeLimit) {
            throw new RuntimeException(new Exception("SCTP chunk limit is set too low and prevents SCTP Forward TSN chunk dispatching."));
        }
        DataBuffer buffer = DataBufferPool.getInstance().take(size);
        buffer.write8((byte)chunk.getType(), 0);
        buffer.write8(0, 1);
        buffer.write16(size, 2);
        buffer.write32(chunk.getNewCumulativeTsnAck(), 4);
        int offset = 8;
        for (int[] numArray2 : streamStreamSequencePairs) {
            buffer.write16(numArray2[0], offset);
            buffer.write16(numArray2[1], offset + 2);
            offset += 4;
        }
        byte[] buffer2 = buffer.toArray();
        buffer.free();
        return buffer2;
    }

    public byte[] getBytes(int sizeLimit) {
        return SctpForwardTsnChunk.getBytes(this, sizeLimit);
    }

    @Override
    public byte[] getBytes() {
        return SctpForwardTsnChunk.getBytes(this, _unset);
    }

    public long getNewCumulativeTsnAck() {
        return this._newCumulativeTsnAck;
    }

    public int[][] getStreamStreamSequencePairs() {
        return this._streamStreamSequencePairs;
    }

    public static SctpForwardTsnChunk parseBytes(byte[] bytes, IntegerHolder offsetPlus) {
        try {
            int num = Binary.fromBytes16(bytes, 2, false);
            long newCumulativeTsnAck = Binary.fromBytes32(bytes, 4, false);
            int inputIndex = 8;
            int num4 = (num - inputIndex) / 4;
            SctpForwardTsnChunk chunk = new SctpForwardTsnChunk(newCumulativeTsnAck);
            if (num4 > 0) {
                int[][] numArray = new int[num4][];
                int num5 = -1;
                int num6 = -1;
                for (int i = 0; i < num4; ++i) {
                    num5 = Binary.fromBytes16(bytes, inputIndex, false);
                    num6 = Binary.fromBytes16(bytes, inputIndex += 2, false);
                    inputIndex += 2;
                    numArray[i] = new int[]{num5, num6};
                }
                chunk.setStreamStreamSequencePairs(numArray);
            }
            offsetPlus.setValue(inputIndex);
            return chunk;
        }
        catch (Exception exception1) {
            offsetPlus.setValue(0);
            return null;
        }
    }

    public SctpForwardTsnChunk(long newCumulativeTsnAck) {
        this(newCumulativeTsnAck, null);
    }

    public SctpForwardTsnChunk(long newCumulativeTsnAck, int[][] streamStreamSequencePairs) {
        super.setType(SctpChunkType.getForwardCumulativeTSN());
        this.setNewCumulativeTsnAck(newCumulativeTsnAck);
        this.setStreamStreamSequencePairs(streamStreamSequencePairs);
        super.setCanBundleWithDataAndSackChunks(true);
        super.setUnrecognized(false);
    }

    public void setNewCumulativeTsnAck(long value) {
        this._newCumulativeTsnAck = value;
    }

    public void setStreamStreamSequencePairs(int[][] value) {
        this._streamStreamSequencePairs = value;
    }
}

