/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayListExtensions;
import fm.icelink.AudioBuffer;
import fm.icelink.AudioTrack;
import fm.icelink.Global;
import fm.icelink.IAction1;
import fm.icelink.IActionDelegate1;
import fm.icelink.MediaBase;
import fm.icelink.MediaTrack;
import fm.icelink.VideoTrack;
import java.util.ArrayList;
import java.util.List;

public abstract class Media<TAudioTrack extends AudioTrack, TVideoTrack extends VideoTrack>
extends MediaBase<TAudioTrack, TVideoTrack> {
    private ArrayList<TAudioTrack> __audioTracks;
    private List<IAction1<Double>> __onAudioLevel = new ArrayList<IAction1<Double>>();
    private ArrayList<TVideoTrack> __videoTracks;
    private boolean _isRecordingAudio;
    private boolean _isRecordingVideo;
    private IAction1<Double> _onAudioLevel = new IAction1<Double>(){

        @Override
        public void invoke(Double p0) {
            for (IAction1 action : new ArrayList(Media.this.__onAudioLevel)) {
                action.invoke(p0);
            }
        }
    };

    protected void addAudioTrack(TAudioTrack audioTrack) {
        if (audioTrack != null && ArrayListExtensions.getCount(this.__audioTracks) == 0) {
            ((AudioTrack)audioTrack).addOnPcmBuffer((IAction1<AudioBuffer>)new IActionDelegate1<AudioBuffer>(){

                @Override
                public String getId() {
                    return "fm.icelink.Media<TAudioTrack,TVideoTrack>.audioTrack_OnPcmBuffer";
                }

                @Override
                public void invoke(AudioBuffer pcmBuffer) {
                    Media.this.audioTrack_OnPcmBuffer(pcmBuffer);
                }
            });
        }
        this.__audioTracks.add(audioTrack);
    }

    @Override
    public void addOnAudioLevel(IAction1<Double> value) {
        this.__onAudioLevel.add(value);
    }

    protected void addVideoTrack(TVideoTrack videoTrack) {
        this.__videoTracks.add(videoTrack);
    }

    protected abstract TAudioTrack[] arrayFromAudioTracks(ArrayList<TAudioTrack> var1);

    protected abstract TVideoTrack[] arrayFromVideoTracks(ArrayList<TVideoTrack> var1);

    private void audioTrack_OnPcmBuffer(AudioBuffer pcmBuffer) {
        IAction1<Double> onAudioLevel = this._onAudioLevel;
        if (onAudioLevel != null) {
            onAudioLevel.invoke(pcmBuffer.calculateLevel());
        }
    }

    protected abstract ArrayList<TAudioTrack> createAudioTrackCollection();

    protected abstract ArrayList<TVideoTrack> createVideoTrackCollection();

    @Override
    public void destroy() {
        for (AudioTrack audioTrack : this.getAudioTracks()) {
            audioTrack.destroy();
        }
        for (MediaTrack mediaTrack : this.getVideoTracks()) {
            mediaTrack.destroy();
        }
    }

    @Override
    public TAudioTrack[] getAudioTracks() {
        return this.arrayFromAudioTracks(this.__audioTracks);
    }

    public boolean getIsRecordingAudio() {
        return this._isRecordingAudio;
    }

    public boolean getIsRecordingVideo() {
        return this._isRecordingVideo;
    }

    @Override
    public TVideoTrack[] getVideoTracks() {
        return this.arrayFromVideoTracks(this.__videoTracks);
    }

    public Media() {
        this.__audioTracks = this.createAudioTrackCollection();
        this.__videoTracks = this.createVideoTrackCollection();
    }

    protected boolean removeAudioTrack(TAudioTrack audioTrack) {
        if (audioTrack != null) {
            ((AudioTrack)audioTrack).removeOnPcmBuffer((IAction1<AudioBuffer>)new IActionDelegate1<AudioBuffer>(){

                @Override
                public String getId() {
                    return "fm.icelink.Media<TAudioTrack,TVideoTrack>.audioTrack_OnPcmBuffer";
                }

                @Override
                public void invoke(AudioBuffer pcmBuffer) {
                    Media.this.audioTrack_OnPcmBuffer(pcmBuffer);
                }
            });
        }
        return this.__audioTracks.remove(audioTrack);
    }

    @Override
    public void removeOnAudioLevel(IAction1<Double> value) {
        IAction1 match;
        if (value instanceof IActionDelegate1 && (match = Global.findIActionDelegate1WithId(this.__onAudioLevel, ((IActionDelegate1)value).getId())) != null) {
            value = match;
        }
        this.__onAudioLevel.remove(value);
    }

    protected boolean removeVideoTrack(TVideoTrack videoTrack) {
        return this.__videoTracks.remove(videoTrack);
    }

    protected void setIsRecordingAudio(boolean value) {
        this._isRecordingAudio = value;
    }

    protected void setIsRecordingVideo(boolean value) {
        this._isRecordingVideo = value;
    }
}

