/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.android;

import android.annotation.SuppressLint;
import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.os.Build;
import fm.icelink.AudioFormat;
import fm.icelink.Log;
import fm.icelink.VideoFormat;
import java.util.ArrayList;

public class MediaCodecUtility {
    public static void logAvailableCodecs() {
        for (MediaCodecInfo info : MediaCodecUtility.getCodecInfos()) {
            String[] types;
            for (String s : types = info.getSupportedTypes()) {
                Log.info((String)((info.isEncoder() ? "Encoder" : "Decoder") + " supported with mime-type '" + s + "' and codec name '" + info.getName() + "'."));
            }
        }
    }

    public static MediaCodecInfo[] getEncoderInfos(String mimeType) {
        return MediaCodecUtility.getCodecInfos(mimeType, -1, false, true);
    }

    public static MediaCodecInfo[] getEncoderInfos(String mimeType, int colorFormat) {
        return MediaCodecUtility.getCodecInfos(mimeType, colorFormat, false, true);
    }

    public static MediaCodecInfo[] getEncoderInfos(String mimeType, int colorFormat, boolean hardwareAcceleratedOnly) {
        return MediaCodecUtility.getCodecInfos(mimeType, colorFormat, hardwareAcceleratedOnly, true);
    }

    public static MediaCodecInfo[] getDecoderInfos(String mimeType) {
        return MediaCodecUtility.getCodecInfos(mimeType, -1, false, false);
    }

    public static MediaCodecInfo[] getDecoderInfos(String mimeType, int colorFormat) {
        return MediaCodecUtility.getCodecInfos(mimeType, colorFormat, false, false);
    }

    public static MediaCodecInfo[] getDecoderInfos(String mimeType, int colorFormat, boolean hardwareAcceleratedOnly) {
        return MediaCodecUtility.getCodecInfos(mimeType, colorFormat, hardwareAcceleratedOnly, false);
    }

    private static MediaCodecInfo[] getCodecInfos(String mimeType, int colorFormat, boolean hardwareAcceleratedOnly, boolean encoders) {
        ArrayList<MediaCodecInfo> codecInfos = new ArrayList<MediaCodecInfo>();
        block0: for (MediaCodecInfo codecInfo : MediaCodecUtility.getCodecInfos()) {
            boolean match = false;
            if (codecInfo.isEncoder() != encoders) continue;
            for (String supportedType : codecInfo.getSupportedTypes()) {
                if (!supportedType.equalsIgnoreCase(mimeType)) continue;
                match = true;
                if (hardwareAcceleratedOnly) {
                    match = MediaCodecUtility.isHardwareAccelerated(codecInfo);
                }
                if (colorFormat >= 0) {
                    match = MediaCodecUtility.hasColorFormat(codecInfo, mimeType, colorFormat);
                }
                if (!match) continue;
                codecInfos.add(codecInfo);
                continue block0;
            }
        }
        return codecInfos.toArray(new MediaCodecInfo[codecInfos.size()]);
    }

    public static boolean hasMimeType(MediaCodecInfo codecInfo, String mimeType) {
        for (String supportedType : codecInfo.getSupportedTypes()) {
            if (!supportedType.equalsIgnoreCase(mimeType)) continue;
            return true;
        }
        return false;
    }

    public static boolean isHardwareAccelerated(MediaCodecInfo codecInfo) {
        return !codecInfo.getName().contains("OMX.google");
    }

    public static boolean hasColorFormat(MediaCodecInfo codecInfo, String mimeType, int colorFormat) {
        for (int codecColorFormat : codecInfo.getCapabilitiesForType((String)mimeType).colorFormats) {
            if (colorFormat != codecColorFormat) continue;
            return true;
        }
        return false;
    }

    @SuppressLint(value={"NewApi"})
    private static MediaCodecInfo[] getCodecInfos() {
        if (Build.VERSION.SDK_INT < 21) {
            int count = MediaCodecList.getCodecCount();
            MediaCodecInfo[] codecInfos = new MediaCodecInfo[count];
            for (int i = 0; i < count; ++i) {
                codecInfos[i] = MediaCodecList.getCodecInfoAt((int)i);
            }
            return codecInfos;
        }
        return new MediaCodecList(0).getCodecInfos();
    }

    private static String getTopLevelType(String mimeType) {
        int indexOfSlash = mimeType.indexOf(47);
        if (indexOfSlash == -1) {
            throw new IllegalArgumentException("Invalid mime type: " + mimeType);
        }
        return mimeType.substring(0, indexOfSlash);
    }

    public static boolean isAudio(String mimeType) {
        return MediaCodecUtility.getTopLevelType(mimeType).equals("audio");
    }

    public static boolean isVideo(String mimeType) {
        return MediaCodecUtility.getTopLevelType(mimeType).equals("video");
    }

    public static String getFormatName(String mimeType) {
        if (mimeType.equals("audio/raw")) {
            return AudioFormat.getPcmName();
        }
        if (mimeType.equals("audio/opus")) {
            return AudioFormat.getOpusName();
        }
        if (mimeType.equals("video/avc")) {
            return VideoFormat.getH264Name();
        }
        if (mimeType.equals("video/x-vnd.on2.vp8")) {
            return VideoFormat.getVp8Name();
        }
        if (mimeType.equals("video/x-vnd.on2.vp9")) {
            return VideoFormat.getVp9Name();
        }
        return null;
    }

    public static String getMimeType(AudioFormat audioFormat) {
        if (audioFormat.getName().equals(AudioFormat.getPcmName())) {
            return "audio/raw";
        }
        if (audioFormat.getName().equals(AudioFormat.getOpusName())) {
            return "audio/opus";
        }
        return null;
    }

    public static String getMimeType(VideoFormat videoFormat) {
        if (videoFormat.getName().equals(VideoFormat.getH264Name())) {
            return "video/avc";
        }
        if (videoFormat.getName().equals(VideoFormat.getVp8Name())) {
            return "video/x-vnd.on2.vp8";
        }
        if (videoFormat.getName().equals(VideoFormat.getVp8Name())) {
            return "video/x-vnd.on2.vp9";
        }
        return null;
    }

    public static int getColorFormat(VideoFormat format) {
        if (format.getName().equals(VideoFormat.getI420Name())) {
            return 19;
        }
        if (format.getName().equals(VideoFormat.getNv21Name())) {
            return 21;
        }
        if (format.getName().equals(VideoFormat.getBgrName())) {
            return 12;
        }
        if (format.getName().equals(VideoFormat.getRgbName())) {
            return 11;
        }
        if (format.getName().equals(VideoFormat.getBgraName())) {
            return 15;
        }
        if (format.getName().equals(VideoFormat.getArgbName())) {
            return 16;
        }
        if (format.getName().equals(VideoFormat.getAbgrName())) {
            return 2130747392;
        }
        return -1;
    }
}

